/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.clean;

import cn.com.yusys.yusp.commons.autoconfigure.clean.DataCleanProperties;
import cn.com.yusys.yusp.commons.clean.config.DataClean;
import cn.com.yusys.yusp.commons.clean.scheduler.SchedulerStarter;
import cn.com.yusys.yusp.commons.clean.task.impl.DataCleanTaskDelete;
import cn.com.yusys.yusp.commons.clean.task.impl.DataCleanTaskMove;
import cn.com.yusys.yusp.commons.clean.task.mapper.DataCleanConfigMapper;
import cn.com.yusys.yusp.commons.clean.task.mapper.DataCleanLogMapper;
import cn.com.yusys.yusp.commons.clean.task.mapper.DataCleanMapper;
import cn.com.yusys.yusp.commons.clean.task.service.DataCleanLogService;
import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@ConditionalOnClass(value={DataCleanLogService.class})
@EnableConfigurationProperties(value={DataCleanProperties.class})
public class DataCleanAutoConfiguration {
    static final String scheduler_bean = "dataCleanThreadPoolTaskScheduler";

    @Bean(value={"dataCleanThreadPoolTaskScheduler"})
    @ConditionalOnMissingBean
    public ThreadPoolTaskScheduler dataCleanThreadPoolTaskScheduler(DataCleanProperties properties) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        List<DataClean> tasks = properties.getConfigs();
        if (null == tasks || tasks.isEmpty()) {
            scheduler.setPoolSize(5);
        } else {
            scheduler.setPoolSize(tasks.size());
        }
        scheduler.setThreadNamePrefix("data-clean-");
        scheduler.setThreadGroupName("data-clean");
        scheduler.initialize();
        return scheduler;
    }

    @Bean
    @ConditionalOnClass(value={MapperScanBasePackage.class})
    public MapperScanBasePackage dataCleanMapperScanBasePackage() {
        return () -> Collections.singletonList("cn.com.yusys.yusp.commons.clean.task.dao");
    }

    @Bean
    public DataCleanProperties dataCleanProperties() {
        return new DataCleanProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataCleanLogService dataCleanLogService(DataCleanLogMapper dataCleanLogMapper, DataCleanConfigMapper dataCleanConfigMapper) {
        return new DataCleanLogService(dataCleanLogMapper, dataCleanConfigMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public SchedulerStarter schedulerStarter(@Qualifier(value="dataCleanThreadPoolTaskScheduler") ThreadPoolTaskScheduler scheduler, DataCleanProperties properties, DataCleanLogService dataCleanLogService) {
        return new SchedulerStarter(scheduler, properties.getConfigs(), dataCleanLogService);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataCleanTaskDelete dataCleanTaskDelete(DataCleanMapper dataCleanMapper) {
        return new DataCleanTaskDelete(dataCleanMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public DataCleanTaskMove dataCleanTaskMove(DataCleanMapper dataCleanMapper) {
        return new DataCleanTaskMove(dataCleanMapper);
    }
}

