/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.biz;

import cn.com.yusys.yusp.commons.biz.BizInterceptorContext;
import cn.com.yusys.yusp.commons.biz.BizMvcHandlerInterceptor;
import cn.com.yusys.yusp.commons.biz.InterceptorType;
import cn.com.yusys.yusp.commons.biz.adapter.DefaultBizMvcHandlerInterceptor;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnExpression(value="'true'.equals('${yusp.mvc.enabled:true}')")
public class BizMvcHandlerInterceptorAutoConfiguration {
    public static final String BEAN_NAME_BIZ_MVC_HANDLER_INTERCEPTOR = "interceptorsExceptionHandler";

    @Bean
    public BizMvcHandlerInterceptor resultDtoExceptionHandleAdapter(@Value(value="${yusp.mvc.default-error-code:500}") String defaultErrorCode) {
        return new DefaultBizMvcHandlerInterceptor(defaultErrorCode);
    }

    @Bean(name={"interceptorsExceptionHandler"})
    public InterceptorsExceptionHandler interceptorsExceptionHandler(ObjectProvider<List<BizMvcHandlerInterceptor>> interceptors) {
        List<BizMvcHandlerInterceptor> errorHandlers = ((List)interceptors.getIfAvailable(ArrayList::new)).stream().filter(interceptor -> interceptor.interceptorType() == InterceptorType.EXCEPTION_HANDLER).collect(Collectors.toList());
        if (CollectionUtils.nonEmpty(errorHandlers)) {
            AnnotationAwareOrderComparator.sort(errorHandlers);
        }
        return new InterceptorsExceptionHandler(errorHandlers);
    }

    @ControllerAdvice
    private static class InterceptorsExceptionHandler
    implements Ordered {
        private final List<BizMvcHandlerInterceptor> bizMvcHandlerInterceptors;

        public InterceptorsExceptionHandler(List<BizMvcHandlerInterceptor> bizMvcHandlerInterceptors) {
            this.bizMvcHandlerInterceptors = bizMvcHandlerInterceptors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExceptionHandler(value={Exception.class})
        @ResponseBody
        public Object handleException(Exception exception, HandlerMethod handlerMethod) throws Exception {
            Object result;
            this.initExceptionContext(exception, handlerMethod);
            try {
                this.runInterceptors();
            }
            finally {
                BizInterceptorContext context = BizInterceptorContext.currentContext();
                result = context.remove((Object)"exceptionHandlerResult");
                context.remove((Object)"exceptionHandlerException");
                context.remove((Object)"exceptionHandlerMethod");
            }
            return result;
        }

        private void runInterceptors() throws Exception {
            for (BizMvcHandlerInterceptor interceptor : this.bizMvcHandlerInterceptors) {
                interceptor.run();
            }
        }

        private void initExceptionContext(Exception e, HandlerMethod handlerMethod) {
            BizInterceptorContext context = BizInterceptorContext.currentContext();
            context.put((Object)"exceptionHandlerException", (Object)e);
            context.put((Object)"exceptionHandlerMethod", (Object)handlerMethod);
        }

        public int getOrder() {
            return 10;
        }
    }
}

