/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.io;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import cn.com.yusys.yusp.commons.util.io.FileUtils;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    public static final String UN_ZIP_FAILED = "\u6587\u4ef6\u89e3\u538b\u7f29\u5931\u8d25";
    public static final String PARAMETER_IS_NULL = "PARAMETER IS NULL";
    public static final String INVALID_PARAMETER_ZIP_PATH = "INVALID_PARAMETER,zipPath must not be the child directory of srcPath.";
    public static final String ZIP_FILE_FAILED = "\u6587\u4ef6\u538b\u7f29\u5931\u8d25";
    private static final Logger logger = LoggerFactory.getLogger(ZipUtils.class);

    public static void zip(String srcPath, String zipPath, String zipFileName) {
        String zipFilePath;
        File zipFile;
        if (StringUtils.isEmpty(srcPath) || StringUtils.isEmpty(zipPath) || StringUtils.isEmpty(zipFileName)) {
            throw new IllegalArgumentException(PARAMETER_IS_NULL);
        }
        File srcFile = new File(srcPath = FileUtils.trimSeparatorSuffix(srcPath));
        if (srcFile.isDirectory() && zipPath.contains(srcPath)) {
            throw new IllegalArgumentException(INVALID_PARAMETER_ZIP_PATH);
        }
        File zipDir = new File(zipPath);
        if (!zipDir.exists() || !zipDir.isDirectory()) {
            zipDir.mkdirs();
        }
        if ((zipFile = new File(zipFilePath = zipPath + File.separator + zipFileName)).exists()) {
            SecurityManager securityManager = new SecurityManager();
            securityManager.checkDelete(zipFilePath);
            try {
                Files.delete(zipFile.toPath());
            }
            catch (IOException e) {
                throw new UtilRuntimeException("zip target file already exists,but can not delete.", e);
            }
        }
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream(zipFile);){
            int index;
            zos.setUseZip64(Zip64Mode.AsNeeded);
            String srcRootDir = srcPath;
            if (srcFile.isFile() && (index = srcPath.lastIndexOf(File.separator)) != -1) {
                srcRootDir = srcPath.substring(0, index);
            }
            ZipUtils.zip(srcRootDir, srcFile, zos);
            zos.finish();
        }
        catch (Exception e) {
            throw new UtilRuntimeException(ZIP_FILE_FAILED, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(String srcRootDir, File file, ZipArchiveOutputStream zos) throws Exception {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            byte[] buffer = new byte[5120];
            int length = -1;
            String subPath = file.getAbsolutePath();
            int index = subPath.indexOf(srcRootDir);
            if (index != -1) {
                subPath = subPath.substring(srcRootDir.length() + File.separator.length());
            }
            ZipArchiveEntry entry = new ZipArchiveEntry(subPath);
            zos.putArchiveEntry((ArchiveEntry)entry);
            try (FileInputStream is = new FileInputStream(file);){
                while ((length = ((InputStream)is).read(buffer)) != -1) {
                    zos.write(buffer, 0, length);
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                zos.closeArchiveEntry();
            }
        } else {
            File[] childFileList = file.listFiles();
            for (int n = 0; n < childFileList.length; ++n) {
                ZipUtils.zip(srcRootDir, childFileList[n], zos);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(String zipFilePath, String unzipFilePath, boolean includeZipFileName) {
        File unzipFileDir;
        if (StringUtils.isEmpty(zipFilePath) || StringUtils.isEmpty(unzipFilePath)) {
            throw new IllegalArgumentException(PARAMETER_IS_NULL);
        }
        File zipFile = new File(zipFilePath);
        if (includeZipFileName) {
            String fileName = zipFile.getName();
            if (StringUtils.nonEmpty(fileName)) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            unzipFilePath = unzipFilePath + File.separator + fileName;
        }
        if (!(unzipFileDir = new File(unzipFilePath)).exists() || !unzipFileDir.isDirectory()) {
            unzipFileDir.mkdirs();
        }
        try (ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(zipFile)));){
            ZipArchiveEntry entry = null;
            while ((entry = zis.getNextZipEntry()) != null) {
                File entryFile = new File(unzipFilePath, entry.getName());
                if (entryFile.exists()) {
                    SecurityManager securityManager = new SecurityManager();
                    securityManager.checkDelete(entryFile.getAbsolutePath());
                    Files.delete(entryFile.toPath());
                }
                if (entry.isDirectory()) {
                    entryFile.mkdir();
                    continue;
                }
                BufferedOutputStream bos = null;
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(new File(unzipFilePath, entry.getName())));
                    IOUtils.copy((InputStream)zis, bos, 1024);
                }
                catch (Exception e) {
                    try {
                        throw new UtilRuntimeException(UN_ZIP_FAILED, e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(bos);
                        throw throwable;
                        return;
                    }
                }
                IOUtils.close(bos);
            }
        }
        catch (Exception e) {
            throw new UtilRuntimeException(UN_ZIP_FAILED, e);
        }
    }

    public static void compressZip(String needZipPath, String targetPath, String fileName) throws IOException {
        String targetFile = StringUtils.builder(100, targetPath, File.separator, fileName);
        Files.deleteIfExists(Paths.get(targetFile, new String[0]));
        try (ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetFile)));){
            File srcFile = new File(needZipPath);
            ZipUtils.compressZip(zipOutput, srcFile, srcFile.getName(), targetFile);
            zipOutput.flush();
        }
    }

    private static void compressZip(ZipOutputStream zipOutput, File file, String base, String targetFile) throws IOException {
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            if (Objects.isNull(listFiles)) {
                return;
            }
            for (File fi : listFiles) {
                if (Objects.equals(fi.getAbsolutePath(), targetFile)) continue;
                if (fi.isDirectory()) {
                    ZipUtils.compressZip(zipOutput, fi, base + "/" + fi.getName(), targetFile);
                    continue;
                }
                ZipUtils.zip(zipOutput, fi, base);
            }
        } else {
            if (Objects.equals(file.getAbsolutePath(), targetFile)) {
                return;
            }
            ZipUtils.zip(zipOutput, file, base);
        }
    }

    public static void zip(ZipOutputStream zipOutput, File file, String base) throws IOException {
        ZipEntry zEntry = new ZipEntry(base + File.separator + file.getName());
        zipOutput.putNextEntry(zEntry);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = bis.read(buffer)) != -1) {
                zipOutput.write(buffer, 0, read);
            }
        }
    }
}

