/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.encrypt;

import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BCRSAUtils {
    private static final Logger log = LoggerFactory.getLogger(BCRSAUtils.class);
    private static RSAPublicKey pubKey = null;
    private static RSAPrivateKey priKey = null;
    private static final String DEFAULT_RSA_ALGORITHM = "RSA/None/PKCS1Padding";

    private BCRSAUtils() {
    }

    private static Key readKey(String keyName) throws IOException, ClassNotFoundException {
        ObjectInputStream keyIn = new ObjectInputStream(BCRSAUtils.class.getClassLoader().getResourceAsStream(keyName));
        Key key = (Key)keyIn.readObject();
        keyIn.close();
        return key;
    }

    public static String decryptByPrivate(String content) {
        return new String(BCRSAUtils.decrypt(priKey, Base64.decodeBase64(content)));
    }

    public static String encryptByPub(String key) {
        return Base64.encodeBase64String(BCRSAUtils.encryptByPub(key.getBytes(), pubKey.getEncoded()));
    }

    public static byte[] decrypt(Key key, byte[] content) {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
            cipher.init(2, key);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new UtilRuntimeException("Decrypt failed.", e);
        }
    }

    public static byte[] encryptByPub(byte[] data, byte[] keyByte) {
        try {
            KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(keyByte);
            PublicKey publicKey = mykeyFactory.generatePublic(pubSpec);
            Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
            cipher.init(1, publicKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new UtilRuntimeException("Encrypt with Public Key failed.", e);
        }
    }

    public static byte[] encryptByPub(byte[] data, String key) {
        return BCRSAUtils.encryptByPub(data, Base64.decodeBase64(key));
    }

    public static String encryptByPrivate(String password) {
        return Base64.encodeBase64String(BCRSAUtils.encryptByPrivate(password.getBytes(), priKey.getEncoded()));
    }

    public static byte[] encryptByPrivate(byte[] data, byte[] keyByte) {
        try {
            KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privateSpec = new PKCS8EncodedKeySpec(keyByte);
            PrivateKey privateKey = mykeyFactory.generatePrivate(privateSpec);
            Cipher cipher = Cipher.getInstance(DEFAULT_RSA_ALGORITHM, "BC");
            cipher.init(1, privateKey);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            throw new UtilRuntimeException("Encrypt with private key failed.", ex);
        }
    }

    public static byte[] encryptByPrivate(byte[] data, String key) {
        return BCRSAUtils.encryptByPrivate(data, Base64.decodeBase64(key));
    }

    public static void createPublicKeyFile(PublicKey key, String filePath) {
        KeyRep pubKeyRep = new KeyRep(KeyRep.Type.PUBLIC, key.getAlgorithm(), key.getFormat(), key.getEncoded());
        try (FileOutputStream fos = new FileOutputStream(filePath);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(pubKeyRep);
            oos.flush();
        }
        catch (Exception ex) {
            throw new UtilRuntimeException("Create public key file failed.", ex);
        }
    }

    public static void createPrivateKeyFile(PrivateKey key, String filePath) {
        KeyRep priKeyRep = new KeyRep(KeyRep.Type.PRIVATE, key.getAlgorithm(), key.getFormat(), key.getEncoded());
        try (FileOutputStream fos = new FileOutputStream(filePath);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(priKeyRep);
            oos.flush();
        }
        catch (Exception ex) {
            throw new UtilRuntimeException("Create private key file failed.", ex);
        }
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            priKey = (RSAPrivateKey)BCRSAUtils.readKey("cert/pwd_private.key");
            pubKey = (RSAPublicKey)BCRSAUtils.readKey("cert/pwd_public.key");
        }
        catch (Exception err) {
            log.warn("Fetch RSA security key file failure, cause by :{}.", (Object)err.getMessage());
        }
    }
}

