/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.date;

import cn.com.yusys.yusp.commons.util.CompareUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.FastDateParser;
import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public class DateUtils {
    public static final String PATTERN_DEFAULT = DateFormatEnum.DEFAULT.getValue();
    public static final String PATTERN_DAY_PATH = DateFormatEnum.DAY_PATH.getValue();
    public static final String PATTERN_DATETIME = DateFormatEnum.DATETIME.getValue();
    public static final String PATTERN_TIME = DateFormatEnum.TIME.getValue();
    public static final String PATTERN_TIME_COMPACT = DateFormatEnum.TIME_COMPACT.getValue();
    public static final String PATTERN_DATETIME_COMPACT = DateFormatEnum.DATETIME_COMPACT.getValue();
    public static final String PATTERN_DATETIME_COMPACT_SSS = DateFormatEnum.DATETIME_COMPACT_SSS.getValue();
    public static final String PATTERN_DATE_COMPACT = DateFormatEnum.DATE_COMPACT.getValue();
    public static final String PATTERN_DATE_SHORT = DateFormatEnum.DATE_SHORT.getValue();
    public static final String PATTERN_YEAR_MONTH = DateFormatEnum.YEAR_MONTH.getValue();
    public static final String PATTERN_YEAR = DateFormatEnum.YEAR.getValue();
    public static final String[] MONTHS_STRING = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    private DateUtils() {
    }

    public static boolean isCurrentYear(Date date) {
        return DateUtils.isCurrentYear(DateUtils.dateToLocalDateTime(date));
    }

    public static boolean isCurrentYear(long time) {
        return DateUtils.isCurrentYear(DateUtils.timestampToLocalDateTime(time));
    }

    public static boolean isCurrentYear(LocalDateTime localDateTime) {
        return DateUtils.isCurrentYear(localDateTime.toLocalDate());
    }

    public static boolean isCurrentYear(LocalDate localDate) {
        return LocalDate.now().getYear() == localDate.getYear();
    }

    public static boolean isCurrentMonth(Date date) {
        return DateUtils.isCurrentMonth(DateUtils.dateToLocalDateTime(date));
    }

    public static boolean isCurrentMonth(long time) {
        LocalDateTime localDateTime = DateUtils.timestampToLocalDateTime(time);
        return DateUtils.isCurrentMonth(localDateTime);
    }

    public static boolean isCurrentMonth(LocalDateTime localDateTime) {
        return DateUtils.isCurrentMonth(localDateTime.toLocalDate());
    }

    public static boolean isCurrentMonth(LocalDate localDate) {
        return DateUtils.isCurrentYear(localDate) && LocalDate.now().getMonth() == localDate.getMonth();
    }

    public static boolean isToday(Date date) {
        return DateUtils.isToday(DateUtils.dateToLocalDateTime(date));
    }

    public static boolean isToday(long time) {
        return DateUtils.isToday(DateUtils.timestampToLocalDateTime(time));
    }

    public static boolean isToday(LocalDateTime localDateTime) {
        return DateUtils.isToday(localDateTime.toLocalDate());
    }

    public static boolean isToday(LocalDate localDate) {
        return LocalDate.now().equals(localDate);
    }

    private static LocalDateTime timestampToLocalDateTime(long time) {
        Instant instant = Instant.ofEpochMilli(time);
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    private static LocalDateTime dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static int getCurrYear() {
        return LocalDate.now().getYear();
    }

    public static int getYear(Date date) {
        return DateUtils.get(date, 1);
    }

    public static int getCurrMonth() {
        return LocalDate.now().getMonth().getValue();
    }

    public static String getCurrentDate(DateFormatEnum format) {
        if (format == DateFormatEnum.TIMESTAMP) {
            return String.valueOf(System.currentTimeMillis());
        }
        return DateTimeFormatter.ofPattern(format.getValue()).format(LocalDateTime.now());
    }

    public static int getMonth(Date date) {
        return DateUtils.get(date, 2) + 1;
    }

    public static int getDayOfWeek(Date date) {
        return DateUtils.get(date, 7) + 1;
    }

    public static int getCurrMonthDay() {
        return DateUtils.getMonthDay(new Date());
    }

    public static int getMonthDay(Date date) {
        return DateUtils.get(date, 5);
    }

    public static int getCurrYearDay() {
        return DateUtils.getYearDay(new Date());
    }

    public static int getYearDay(Date date) {
        return DateUtils.get(date, 6);
    }

    public static int getDayHour(Date date) {
        return DateUtils.get(date, 11);
    }

    public static int getCurrDayHour() {
        return DateUtils.getDayHour(new Date());
    }

    public static int getCurrMinute() {
        return DateUtils.getMinute(new Date());
    }

    public static int getMinute(Date date) {
        return DateUtils.get(date, 12);
    }

    public static int getCurrSecond() {
        return DateUtils.getSecond(new Date());
    }

    public static int getSecond(Date date) {
        return DateUtils.get(date, 13);
    }

    public static int get(Date date, int field) {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setTime(date);
        return calendar.get(field);
    }

    public static int compare(Date date1, Date date2) {
        return CompareUtils.compare(date1, date2);
    }

    public static Date addYear(int amount) {
        return DateUtils.addYear(new Date(), amount);
    }

    public static Date addYear(Date date, int amount) {
        return DateUtils.add(date, 1, amount);
    }

    public static String addYear(String date, String pattern, int amount) {
        return DateUtils.formatDate(DateUtils.addYear(DateUtils.parseDate(date, pattern), amount), pattern);
    }

    public static String addYear(Date date, String pattern, int amount) {
        return DateUtils.formatDate(DateUtils.addYear(date, amount), pattern);
    }

    public static Date addMonth(int amount) {
        return DateUtils.addMonth(new Date(), amount);
    }

    public static Date addMonth(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }

    public static String addMonth(String date, String pattern, int amount) {
        return DateUtils.formatDate(DateUtils.addMonth(DateUtils.parseDate(date, pattern), amount), pattern);
    }

    public static String addMonth(Date date, String pattern, int amount) {
        return DateUtils.formatDate(DateUtils.addMonth(date, amount), pattern);
    }

    public static Date addDay(int amount) {
        return DateUtils.addDay(new Date(), amount);
    }

    public static Date addDay(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static String addDay(String date, String pattern, int amount) {
        return DateUtils.formatDate(DateUtils.addDay(DateUtils.parseDate(date, pattern), amount), pattern);
    }

    public static String addDay(Date date, String pattern, int amount) {
        return DateUtils.formatDate(DateUtils.addDay(date, amount), pattern);
    }

    public static Date add(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static String formatDate(String pattern) {
        return DateUtils.formatDate(new Date(), pattern);
    }

    public static String formatDate(Date date, String pattern) {
        return Objects.nonNull(date) ? new SimpleDateFormat(pattern, Locale.CHINA).format(date) : null;
    }

    public static String formatDateByDef() {
        return DateUtils.formatDate(PATTERN_DEFAULT);
    }

    public static String formatDateByDef(Date date) {
        return DateUtils.formatDate(date, PATTERN_DEFAULT);
    }

    public static String formatDateTimeByDef() {
        return DateUtils.formatDate(PATTERN_DATETIME);
    }

    public static String formatDateTimeByDef(Date date) {
        return DateUtils.formatDate(date, PATTERN_DATETIME);
    }

    public static Date parseDate(String date, String pattern) {
        try {
            return StringUtils.nonEmpty(date) ? new SimpleDateFormat(pattern).parse(date) : null;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(DateUtils.class).warn("Time format exception[{}][{}],msg:[{}].", new Object[]{date, pattern, e.getMessage()});
            return null;
        }
    }

    public static Date parseDate(String str, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDate(str, null, parsePatterns);
    }

    public static Date parseDate(String str, Locale locale, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDateWithLeniency(str, locale, parsePatterns, true);
    }

    public static Date parseDateStrictly(String str, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDateStrictly(str, null, parsePatterns);
    }

    public static Date parseDateStrictly(String str, Locale locale, String ... parsePatterns) throws ParseException {
        return DateUtils.parseDateWithLeniency(str, locale, parsePatterns, false);
    }

    private static Date parseDateWithLeniency(String str, Locale locale, String[] parsePatterns, boolean lenient) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = locale == null ? Locale.getDefault() : locale;
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : parsePatterns) {
            FastDateParser fdp = new FastDateParser(parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(str, pos, calendar) && pos.getIndex() == str.length()) {
                    return calendar.getTime();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static Date parseDateByDef(String date) {
        return DateUtils.parseDate(date, PATTERN_DEFAULT);
    }

    public static Date parseDateTimeByDef(String date) {
        return DateUtils.parseDate(date, PATTERN_DATETIME);
    }

    public static int getMonthsByTwoDates(Date startDate, Date endDate) {
        int month = 0;
        Calendar start = Calendar.getInstance(Locale.CHINA);
        Calendar end = Calendar.getInstance(Locale.CHINA);
        start.setTime(startDate);
        end.setTime(endDate);
        month = (end.get(1) - start.get(1)) * 12 + end.get(2) - start.get(2);
        start.add(2, month);
        return start.after(end) ? month - 1 : month;
    }

    public static int getMonthsByTwoDates(String startDate, String endDate, String pattern) {
        return DateUtils.getMonthsByTwoDates(startDate, pattern, endDate, pattern);
    }

    public static int getMonthsByTwoDates(String startDate, String startPattern, String endDate, String endPattern) {
        return DateUtils.getMonthsByTwoDates(DateUtils.parseDate(startDate, startPattern), DateUtils.parseDate(endDate, endPattern));
    }

    public static int getMonthsByTwoDatesDef(String startDate, String endDate) {
        return DateUtils.getMonthsByTwoDates(startDate, endDate, PATTERN_DEFAULT);
    }

    public static int getDaysByTwoDates(Date startDate, Date endDate) {
        if (Objects.isNull(startDate)) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a");
        }
        if (Objects.isNull(endDate)) {
            throw new IllegalArgumentException("\u4f20\u5165\u7684\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a");
        }
        return (int)((endDate.getTime() - startDate.getTime()) / 1000L / 60L / 60L / 24L);
    }

    public static int getDaysByTwoDates(String startDate, String endDate, String pattern) {
        return DateUtils.getDaysByTwoDates(startDate, pattern, endDate, pattern);
    }

    public static int getDaysByTwoDates(String startDate, String startPattern, String endDate, String endPattern) {
        return DateUtils.getDaysByTwoDates(DateUtils.parseDate(startDate, startPattern), DateUtils.parseDate(endDate, endPattern));
    }

    public static int getDaysByTwoDatesDef(String startDate, String endDate) {
        return DateUtils.getDaysByTwoDates(startDate, endDate, PATTERN_DEFAULT);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static boolean isLeapYear(String year) {
        return StringUtils.nonEmpty(year) && DateUtils.isLeapYear(Integer.parseInt(year));
    }

    public static String getYesterday(String date) throws Exception {
        return DateUtils.getYesterday(date, PATTERN_DEFAULT);
    }

    public static String getYesterday(Date date) throws Exception {
        return DateUtils.formatDate(DateUtils.getYesterday(date, PATTERN_DEFAULT), PATTERN_DEFAULT);
    }

    public static String getYesterday(String date, String pattern) throws Exception {
        return DateUtils.addDay(date, pattern, -1);
    }

    public static Date getYesterday(Date date, String pattern) throws Exception {
        return DateUtils.addDay(date, -1);
    }

    public static String getTomorrow(String date) throws Exception {
        return DateUtils.getTomorrow(date, PATTERN_DEFAULT);
    }

    public static String getTomorrow(Date date) throws Exception {
        return DateUtils.formatDate(DateUtils.getTomorrow(date, PATTERN_DEFAULT), PATTERN_DEFAULT);
    }

    public static String getTomorrow(String date, String pattern) throws Exception {
        return DateUtils.addDay(date, pattern, 1);
    }

    public static Date getTomorrow(Date date, String pattern) throws Exception {
        return DateUtils.addDay(date, 1);
    }

    public static int getEndMonthOfQuarter(int month) {
        return ((month - 1) / 3 + 1) * 3;
    }

    public static int getEndMonthOfQuarter(String month) {
        return DateUtils.getEndMonthOfQuarter(Integer.parseInt(month));
    }

    public static String getCurrDateStr() {
        return DateUtils.formatDateByDef();
    }

    public static String getCurrDateTimeStr() {
        return DateUtils.formatDateTimeByDef();
    }

    public static String getCurrTime() {
        return DateUtils.formatDate(PATTERN_TIME);
    }

    public static String getTimeStampByPattern(String pattern) {
        return DateUtils.formatDate(pattern);
    }

    public static String getCurrStringMonth() {
        return DateUtils.getStringMonth(DateUtils.getCurrMonth());
    }

    public static String getStringMonth(Date date) {
        return DateUtils.getStringMonth(DateUtils.getMonth(date));
    }

    public static String getStringMonth(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid value for MonthOfYear (valid values 1 - 12): " + month);
        }
        return MONTHS_STRING[month - 1];
    }

    public static String getStringMonth(String month) {
        return DateUtils.getStringMonth(Integer.parseInt(month));
    }

    public static String bZeroMonth(int month) {
        return month < 10 ? "0" + month : String.valueOf(month);
    }

    public static int getMonthTotalDays(int year, int month) {
        int days = 1;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                days = 31;
                break;
            }
            case 2: {
                days = DateUtils.isLeapYear(year) ? 29 : 28;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                days = 30;
                break;
            }
            default: {
                throw new UtilRuntimeException("no match month");
            }
        }
        return days;
    }

    public static String formatDate8To10(String date) {
        return StringUtils.nonEmpty(date) ? DateUtils.formatDateByDef(DateUtils.parseDate(date, PATTERN_DATE_COMPACT)) : null;
    }

    public static String formatDate10To8(String date) {
        return StringUtils.nonEmpty(date) ? DateUtils.formatDate(DateUtils.parseDateByDef(date), PATTERN_DATE_COMPACT) : null;
    }

    public static String formatDateTime14To19(String date) {
        return StringUtils.nonEmpty(date) ? DateUtils.formatDate(DateUtils.parseDate(date, PATTERN_DATETIME_COMPACT), PATTERN_DATETIME) : null;
    }

    public static String formatDateTime19To14(String date) {
        return StringUtils.nonEmpty(date) ? DateUtils.formatDate(DateUtils.parseDate(date, PATTERN_DATETIME), PATTERN_DATETIME_COMPACT) : null;
    }

    public static String formatTime6To8(String date) {
        return StringUtils.nonEmpty(date) ? DateUtils.formatDate(DateUtils.parseDate(date, PATTERN_TIME_COMPACT), PATTERN_TIME) : null;
    }

    public static String formatTime8To6(String date) {
        return StringUtils.nonEmpty(date) ? DateUtils.formatDate(DateUtils.parseDate(date, PATTERN_TIME), PATTERN_TIME_COMPACT) : null;
    }

    public static boolean checkDate(String dateStr) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher matcher = pattern.matcher(dateStr);
        return matcher.matches();
    }

    public static String getStartDateByMonths(Date endDate, int months) {
        return DateUtils.formatDateByDef(DateUtils.addMonth(endDate, 0 - months));
    }

    public static String getStartDateByMonths(String endDate, int months) {
        return DateUtils.getStartDateByMonths(DateUtils.parseDateByDef(endDate), months);
    }

    public static String getStartDateByMonths(String endDate, String pattern, int months) {
        return DateUtils.formatDate(DateUtils.addMonth(DateUtils.parseDate(endDate, pattern), 0 - months), pattern);
    }

    public static Date object2Date(Object object, String pattern) {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof Calendar) {
            Calendar cal = (Calendar)object;
            date = cal.getTime();
        } else if (object instanceof String) {
            String str = String.valueOf(object);
            date = DateUtils.parseDate(str, pattern);
        }
        return date;
    }

    public static Date getCurrDate() {
        return new Date();
    }

    public static Timestamp getCurrTimestamp() {
        return new Timestamp(DateUtils.getCurrDate().getTime());
    }
}

