/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util.collection;

import cn.com.yusys.yusp.commons.util.collection.KeyValue;
import java.util.Map;
import java.util.Objects;

public class Entry<K, V>
implements KeyValue<K, V>,
Map.Entry<K, V> {
    private K key;
    private V value;

    public Entry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public static <K, V> Entry<K, V> of(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public void setKey(K key) {
        this.key = key;
    }

    @Override
    public V setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entry entry = (Entry)o;
        return Objects.equals(this.key, entry.key) && Objects.equals(this.value, entry.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return String.format("Entry[key=%s, value=%s]", this.key == null ? "" : this.key.toString(), this.value == null ? "" : this.value.toString());
    }
}

