/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.exception.UtilRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class ByteUtils {
    public static final String NEGATIVE_NOT_SUPPORT_EX_MSG = "Data[%s]is negative, and int2DecBcdByte does not support negative";
    public static final String LESS_THEN_ACTUAL_LENGTH_EX_MSG = "The target length[%d]is less than the actual length[%d]";
    public static final String NULL_ARRAY_NOTSUPPORT_EX_MSG = "Byte tool class slices byte array method according to exception rule @ source data is empty";
    public static final String START_POS_MUST_LESS_THAN_SOURCE_LENGTH_EX_MSG = "Byte tool class slices byte array method according to exception rule @ The start point[%d]is less than 0 or greater than source data length[%d]";
    public static final String LNGTH_MUST_LESS_THAN_15 = "Byte tool class @ illegal filled element, must be 0-15";
    public static final String INVALID_DATA_THE_FILLING_RESULT_IS_EMPTY = "Invalid data, the filling result is empty.";
    private static final String CONVERT_DATA_INT_EX_MSG = "Convert data[%s]to int exception.";
    private static final char CHAR_4 = 'x';
    private static final char CHAR_3 = ';';
    private static final char CHAR_2 = '#';
    private static final char CHAR_1 = '&';
    private static byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static byte[] digits2 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] SIZE_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final byte[] DIGIT_ONES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] DIGIT_ONES_2 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final byte[] DIGIT_TENS = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DIGIT_TENS_2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteUtils() {
    }

    public static char[] encode(byte[] bytes) {
        int nBytes = bytes.length;
        char[] result = new char[2 * nBytes];
        int j = 0;
        for (int i = 0; i < nBytes; ++i) {
            result[j++] = HEX[(0xF0 & bytes[i]) >>> 4];
            result[j++] = HEX[0xF & bytes[i]];
        }
        return result;
    }

    public static byte[] decode(CharSequence s) {
        int nChars = s.length();
        if (nChars % 2 != 0) {
            throw new IllegalArgumentException("Hex-encoded string must have an even number of characters");
        }
        byte[] result = new byte[nChars / 2];
        for (int i = 0; i < nChars; i += 2) {
            int msb = Character.digit(s.charAt(i), 16);
            int lsb = Character.digit(s.charAt(i + 1), 16);
            if (msb < 0 || lsb < 0) {
                throw new IllegalArgumentException("Detected a Non-hex character at " + (i + 1) + " or " + (i + 2) + " position");
            }
            result[i / 2] = (byte)(msb << 4 | lsb);
        }
        return result;
    }

    public static byte[] addBytes(byte[] srcBytes, byte[] addBytes) {
        if (srcBytes == null || addBytes == null) {
            return srcBytes;
        }
        int srcLength = srcBytes.length;
        int addLength = addBytes.length;
        byte[] retBytes = new byte[srcLength + addLength];
        System.arraycopy(srcBytes, 0, retBytes, 0, srcLength);
        System.arraycopy(addBytes, 0, retBytes, srcLength, addLength);
        return retBytes;
    }

    public static byte[] asc2Bcd(byte[] srcData) {
        int len = srcData.length;
        if (len % 2 == 1) {
            byte[] tmpArrray = new byte[len + 1];
            System.arraycopy(srcData, 0, tmpArrray, 0, len - 1);
            tmpArrray[len] = srcData[len - 1];
            srcData = tmpArrray;
        }
        int size = srcData.length / 2;
        byte[] retArray = new byte[size];
        for (int i = 0; i < size; ++i) {
            int high = 0;
            high = srcData[2 * i] >= 97 && srcData[2 * i] <= 102 ? srcData[2 * i] - 97 + 10 : (srcData[2 * i] >= 65 && srcData[2 * i] <= 70 ? srcData[2 * i] - 65 + 10 : srcData[2 * i] & 0xF);
            int low = 0;
            low = srcData[2 * i + 1] >= 97 && srcData[2 * i + 1] <= 102 ? srcData[2 * i + 1] - 97 + 10 : (srcData[2 * i + 1] >= 65 && srcData[2 * i + 1] <= 70 ? srcData[2 * i + 1] - 65 + 10 : srcData[2 * i + 1] & 0xF);
            retArray[i] = (byte)((high << 4) + low);
        }
        return retArray;
    }

    public static byte[] asc2Bcd(byte[] srcData, int fillChar, boolean isLeft) {
        if (srcData == null || srcData.length == 0) {
            return srcData;
        }
        if (srcData.length % 2 == 1) {
            byte[] ascArray = new byte[srcData.length + 1];
            byte fill = 0;
            if (fillChar >= 0 && fillChar <= 9) {
                fill = (byte)(fillChar + 48);
            } else if (fillChar >= 10 && fillChar <= 15) {
                fill = (byte)(fillChar - 10 + 97);
            } else {
                throw new UtilRuntimeException(LNGTH_MUST_LESS_THAN_15);
            }
            if (isLeft) {
                ascArray[0] = fill;
                System.arraycopy(srcData, 0, ascArray, 1, srcData.length);
            } else {
                System.arraycopy(srcData, 0, ascArray, 0, srcData.length);
                ascArray[ascArray.length - 1] = fill;
            }
            return ByteUtils.asc2Bcd(ascArray);
        }
        return ByteUtils.asc2Bcd(srcData);
    }

    public static byte[] asc2Bcd(byte[] srcData, int fillChar, boolean isLeft, int len) {
        if (srcData == null || srcData.length == 0) {
            return srcData;
        }
        len = len % 2 != 0 ? len + 1 : len;
        byte[] srcBcdArray = ByteUtils.asc2Bcd(srcData, fillChar, isLeft);
        if (srcBcdArray == null) {
            throw new UtilRuntimeException(INVALID_DATA_THE_FILLING_RESULT_IS_EMPTY);
        }
        if (srcData.length > len) {
            return srcBcdArray;
        }
        int fillSize = len - srcBcdArray.length * 2;
        if (fillSize > 0) {
            byte[] bcdArray = new byte[srcBcdArray.length + fillSize / 2];
            byte[] fillBcdArray = new byte[fillSize / 2];
            byte fill = (byte)(fillChar + fillChar * 16);
            for (int i = 0; i < fillSize / 2; ++i) {
                fillBcdArray[i] = fill;
            }
            if (isLeft) {
                System.arraycopy(fillBcdArray, 0, bcdArray, 0, fillBcdArray.length);
                System.arraycopy(srcBcdArray, 0, bcdArray, fillBcdArray.length, srcBcdArray.length);
            } else {
                System.arraycopy(srcBcdArray, 0, bcdArray, 0, srcBcdArray.length);
                System.arraycopy(fillBcdArray, 0, bcdArray, srcBcdArray.length, fillBcdArray.length);
            }
            return bcdArray;
        }
        return srcBcdArray;
    }

    public static byte[] bcd2Asc(byte[] srcData) {
        return ByteUtils.bcd2Asc(srcData, true);
    }

    public static byte[] bcd2Asc(byte[] srcData, boolean lowercase) {
        if (srcData == null || srcData.length == 0) {
            return srcData;
        }
        int length = srcData.length;
        byte[] ascArray = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            int bcd = srcData[i];
            if (bcd < 0) {
                bcd += 256;
            }
            byte high = (byte)(bcd >>> 4);
            ascArray[i * 2] = high = ByteUtils.toAscII(high, lowercase);
            byte low = (byte)(bcd & 0xF);
            ascArray[i * 2 + 1] = low = ByteUtils.toAscII(low, lowercase);
        }
        return ascArray;
    }

    private static byte toAscII(byte origin, boolean lowercase) {
        origin = 0 <= origin && origin <= 9 ? (byte)(origin + 48) : ByteUtils.lowCase(origin, lowercase);
        return origin;
    }

    private static byte lowCase(byte code, boolean lowercase) {
        code = lowercase ? (byte)(code + 87) : (byte)(code + 55);
        return code;
    }

    private static int lowCase(int code, boolean lowercase) {
        code = lowercase ? (code += 87) : (code += 55);
        return code;
    }

    public static byte[] bcd2Asc(byte[] srcData, int stripChar, boolean isLeft) {
        return ByteUtils.bcd2Asc(srcData, stripChar, isLeft, true);
    }

    public static byte[] bcd2Asc(byte[] srcData, int stripChar, boolean isLeft, boolean lowercase) {
        if (srcData == null || srcData.length == 0) {
            return srcData;
        }
        byte[] ascArray = ByteUtils.bcd2Asc(srcData);
        byte[] tmpArray = null;
        stripChar = 0 <= stripChar && stripChar <= 9 ? (stripChar += 48) : (lowercase ? (stripChar += 87) : (stripChar += 55));
        tmpArray = isLeft ? ByteUtils.stripStart(ascArray, (byte)stripChar) : ByteUtils.stripEnd(ascArray, (byte)stripChar);
        return tmpArray;
    }

    public static byte[] bcd2Asc(byte[] srcData, int stripChar, boolean isLeft, int len) {
        return ByteUtils.bcd2Asc(srcData, stripChar, isLeft, len, true);
    }

    public static byte[] bcd2Asc(byte[] srcData, int stripChar, boolean isLeft, int len, boolean lowercase) {
        if (srcData == null || srcData.length == 0) {
            return srcData;
        }
        byte[] ascArray = ByteUtils.bcd2Asc(srcData);
        stripChar = 0 <= stripChar && stripChar <= 9 ? (stripChar += 48) : ByteUtils.lowCase(stripChar, lowercase);
        byte[] tmpArray = new byte[len];
        if (ascArray.length > len) {
            if (isLeft) {
                System.arraycopy(ascArray, ascArray.length - len, tmpArray, 0, len);
            } else {
                System.arraycopy(ascArray, 0, tmpArray, 0, len);
            }
        } else {
            tmpArray = isLeft ? ByteUtils.leftPad(ascArray, len, (byte)stripChar) : ByteUtils.rightPad(ascArray, len, (byte)stripChar);
        }
        return tmpArray;
    }

    public static int byte2int(byte[] bytes) {
        if (bytes == null || bytes.length > 4) {
            return 0;
        }
        int intVal = 0;
        for (byte aByte : bytes) {
            intVal <<= 8;
            intVal ^= aByte & 0xFF;
        }
        return intVal;
    }

    public static long byte2long(byte[] bytes) {
        if (bytes == null || bytes.length > 8) {
            return 0L;
        }
        long longVal = 0L;
        for (int i = 0; i < 8; ++i) {
            longVal <<= 8;
            longVal ^= (long)(bytes[i] & 0xFF);
        }
        return longVal;
    }

    public static short byte2short(byte[] byteDate) {
        if (byteDate == null || byteDate.length > 2) {
            return 0;
        }
        short shortVal = 0;
        for (byte b : byteDate) {
            shortVal = (short)(shortVal << 8);
            shortVal = (short)(shortVal ^ b & 0xFF);
        }
        return shortVal;
    }

    public static Number bytes2num(byte[] byteData) {
        long num = 0L;
        for (int i = 0; i < byteData.length; ++i) {
            num <<= 8;
            num ^= (long)(byteData[i] & 0xFF);
        }
        return num;
    }

    public static byte[] centerPad(byte[] bytes, int len, byte padByte) {
        if (bytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        int left = srcLen / 2;
        int right = srcLen - left;
        System.arraycopy(bytes, 0, byRet, 0, left);
        for (int i = left; i < left + len - srcLen; ++i) {
            byRet[i] = padByte;
        }
        System.arraycopy(bytes, left, byRet, left + len - srcLen, right);
        return byRet;
    }

    public static byte[] centerPad(byte[] bytes, int len, byte[] padBytes) {
        if (bytes == null || padBytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        int left = srcLen / 2;
        int right = srcLen - left;
        System.arraycopy(bytes, 0, byRet, 0, left);
        int padSzie = len - srcLen;
        int length = padBytes.length;
        int count = padSzie / length;
        for (int i = 0; i < count; ++i) {
            System.arraycopy(padBytes, 0, byRet, left + i * length, length);
        }
        int surplus = padSzie % length;
        System.arraycopy(padBytes, 0, byRet, left + count * length, surplus);
        System.arraycopy(bytes, left, byRet, left + len - srcLen, right);
        return byRet;
    }

    public static boolean contains(byte[] bytes, byte indexByte) {
        boolean containFlag = false;
        if (bytes == null) {
            return containFlag;
        }
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] != indexByte) continue;
            containFlag = true;
            break;
        }
        return containFlag;
    }

    public static boolean contrastBytes(byte[] source, int index, byte[] target) {
        int len = target.length;
        if (source.length - index < len || len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (source[index + i] == target[i]) continue;
            return false;
        }
        return true;
    }

    public static int decAsciiByte2int(byte[] byteArray) {
        int radix = 10;
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = byteArray.length;
        if (max > 0) {
            IntegerArray integerArray = new IntegerArray(byteArray, radix, result, negative, i, max).invoke();
            result = integerArray.getResult();
            negative = integerArray.isNegative();
            i = integerArray.getI();
        } else {
            ByteUtils.convertDataIntEx(byteArray);
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
        } else {
            return -result;
        }
        ByteUtils.convertDataIntEx(byteArray);
        return ByteUtils.convertDataIntEx(byteArray);
    }

    private static int convertDataIntEx(byte[] byteArray) {
        throw new UtilRuntimeException(String.format(CONVERT_DATA_INT_EX_MSG, new String(byteArray)));
    }

    public static int decBcdByte2int(byte[] byteArray, boolean isLeftFill, int fillchar) {
        int val = 0;
        int pow = 1;
        int tmpVal = 0;
        int tmpRes = 0;
        int length = byteArray.length;
        for (int i = length - 1; i >= 0; --i) {
            tmpRes = byteArray[i] & 0xFF;
            do {
                tmpVal = tmpRes % 16;
                val += tmpVal * pow;
                pow *= 10;
            } while ((tmpRes /= 16) != 0);
        }
        return val;
    }

    public static int decByte2int(byte[] byteArray) {
        int val = 0;
        int length = byteArray.length;
        int pow = 1;
        for (int i = length - 1; i >= 0; --i) {
            val += byteArray[i] * pow;
            pow *= 10;
        }
        return val;
    }

    public static boolean equals(byte[] srcData, byte[] destData) {
        if (srcData == null && destData == null) {
            return true;
        }
        if (srcData != null && destData != null) {
            int srcLength = srcData.length;
            int destLength = destData.length;
            if (srcLength == destLength) {
                for (int i = 0; i < destLength; ++i) {
                    if (srcData[i] == destData[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static byte[] getBytes(Object object) {
        if (object == null) {
            return new byte[0];
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return object.toString().getBytes();
    }

    public static byte[] getBytes(Object object, String charset) throws UnsupportedEncodingException {
        if (object == null) {
            return new byte[0];
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes(charset);
        }
        if (object instanceof Character) {
            return ((Character)object).toString().getBytes(charset);
        }
        return object.toString().getBytes();
    }

    public static int hexAsciiByte2int(byte[] byteArray) {
        int val = 0;
        int length = byteArray.length;
        int pow = 1;
        int tmpVal = 0;
        for (int i = length - 1; i >= 0; --i) {
            tmpVal = byteArray[i] > 57 ? byteArray[i] - 55 : byteArray[i] - 48;
            val += tmpVal * pow;
            pow *= 16;
        }
        return val;
    }

    public static int hexBcdByte2int(byte[] byteArray, boolean isLeftFill, int fillchar) {
        int val = 0;
        int pow = 1;
        int tmpVal = 0;
        int tmpRes = 0;
        int length = byteArray.length;
        for (int i = length - 1; i >= 0; --i) {
            tmpRes = byteArray[i] & 0xFF;
            do {
                tmpVal = tmpRes % 16;
                val += tmpVal * pow;
                pow *= 16;
            } while ((tmpRes /= 16) != 0);
        }
        return val;
    }

    public static int indexOf(byte[] bytes, byte indexByte) {
        int index = -1;
        if (bytes == null) {
            return index;
        }
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] != indexByte) continue;
            index = i;
            break;
        }
        return index;
    }

    public static byte[] int2byte(int val) {
        return new byte[]{(byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
    }

    public static byte[] int2DecAsciiByte(int val) {
        int r;
        int q;
        int size = val < 0 ? ByteUtils.stringSize(-val) + 1 : ByteUtils.stringSize(val);
        byte[] buf = new byte[size];
        int charPos = size;
        int sign = 0;
        if (val < 0) {
            sign = 45;
            val = -val;
        }
        while (val >= 65536) {
            q = val / 100;
            r = val - ((q << 6) + (q << 5) + (q << 2));
            val = q;
            buf[--charPos] = DIGIT_ONES[r];
            buf[--charPos] = DIGIT_TENS[r];
        }
        do {
            q = val * 52429 >>> 19;
            r = val - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((val = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
        return buf;
    }

    public static byte[] int2DecBcdByte(int value, boolean isLeftFill, int fillchar, int len) {
        int r;
        int q;
        int size;
        if (value < 0) {
            throw new UtilRuntimeException(String.format(NEGATIVE_NOT_SUPPORT_EX_MSG, value));
        }
        ByteUtils.validateStartPos(len, size, len < (size = ByteUtils.stringSize(value)), LESS_THEN_ACTUAL_LENGTH_EX_MSG);
        byte[] buf = new byte[size];
        int charPos = size;
        while (value >= 65536) {
            q = value / 100;
            r = value - ((q << 6) + (q << 5) + (q << 2));
            value = q;
            buf[--charPos] = DIGIT_ONES_2[r];
            buf[--charPos] = DIGIT_TENS_2[r];
        }
        do {
            q = value * 52429 >>> 19;
            r = value - ((q << 3) + (q << 1));
            buf[--charPos] = digits2[r];
        } while ((value = q) != 0);
        return ByteUtils.getBytes(isLeftFill, fillchar, len, size, buf);
    }

    private static byte[] getBytes(boolean isLeftFill, int fillChar, int len, int size, byte[] buf) {
        byte[] bt = new byte[(len + 1) / 2];
        int btLen = bt.length;
        if (isLeftFill) {
            ByteUtils.leftFill(fillChar, size, buf, bt, btLen);
        } else {
            ByteUtils.rightFill(fillChar, size, buf, bt, btLen);
        }
        return bt;
    }

    private static void rightFill(int fillChar, int size, byte[] buf, byte[] bt, int btLen) {
        for (int i = 0; i < btLen; ++i) {
            int n1 = fillChar;
            if (2 * i < size) {
                n1 = buf[2 * i];
            }
            int n2 = fillChar;
            if (2 * i + 1 < size) {
                n2 = buf[2 * i + 1];
            }
            bt[i] = (byte)(16 * n1 + n2);
        }
    }

    private static void leftFill(int fillChar, int size, byte[] buf, byte[] bt, int btLen) {
        for (int i = 0; i < btLen; ++i) {
            int n1 = fillChar;
            if (2 * i < size) {
                n1 = buf[size - 2 * i - 1];
            }
            int n2 = fillChar;
            if (2 * i + 1 < size) {
                n2 = buf[size - (2 * i + 2)];
            }
            bt[btLen - i - 1] = (byte)(16 * n2 + n1);
        }
    }

    public static byte[] int2DecByte(int val) {
        ArrayList<Integer> byteList = new ArrayList<Integer>();
        int comprared = 1;
        int tmpVal = val;
        while (true) {
            byteList.add(tmpVal % 10);
            if ((comprared *= 10) > Math.abs(val)) break;
            tmpVal /= 10;
        }
        int size = byteList.size();
        byte[] retByte = new byte[size];
        for (int i = 0; i < size; ++i) {
            retByte[size - i - 1] = ((Integer)byteList.get(i)).byteValue();
        }
        return retByte;
    }

    public static byte[] int2HexAsciiByte(int val) {
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits[val & mask];
        } while ((val >>>= 4) != 0);
        int len = 32 - charPos;
        byte[] res = new byte[len];
        System.arraycopy(buf, charPos, res, 0, len);
        return res;
    }

    public static byte[] int2HexBcdByte(int value, boolean isLeftFill, int fillchar, int len) {
        int resLen;
        if (value < 0) {
            throw new UtilRuntimeException(String.format(NEGATIVE_NOT_SUPPORT_EX_MSG, value));
        }
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 16;
        int mask = radix - 1;
        do {
            buf[--charPos] = digits2[value & mask];
        } while ((value >>>= 4) != 0);
        ByteUtils.validateStartPos(len, resLen, len < (resLen = 32 - charPos), LESS_THEN_ACTUAL_LENGTH_EX_MSG);
        return ByteUtils.getBytes(isLeftFill, fillchar, len, resLen, buf);
    }

    public static byte[] leftPad(byte[] bytes, int len, byte padByte) {
        if (bytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        for (int i = 0; i < len - srcLen; ++i) {
            byRet[i] = padByte;
        }
        System.arraycopy(bytes, 0, byRet, len - srcLen, srcLen);
        return byRet;
    }

    public static byte[] leftPad(byte[] bytes, int len, byte[] padBytes) {
        if (bytes == null || padBytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        int padSzie = len - srcLen;
        int length = padBytes.length;
        int count = padSzie / length;
        for (int i = 0; i < count; ++i) {
            System.arraycopy(padBytes, 0, byRet, i * length, length);
        }
        int surplus = padSzie % length;
        for (int i = 0; i < surplus; ++i) {
            System.arraycopy(padBytes, 0, byRet, count * length, surplus);
        }
        System.arraycopy(bytes, 0, byRet, len - srcLen, srcLen);
        return byRet;
    }

    public static byte[] long2byte(long val) {
        return new byte[]{(byte)(val >> 56), (byte)(val >> 48), (byte)(val >> 40), (byte)(val >> 32), (byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
    }

    public static byte[] rightPad(byte[] bytes, int len, byte padByte) {
        if (bytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        System.arraycopy(bytes, 0, byRet, 0, srcLen);
        for (int i = srcLen; i < len; ++i) {
            byRet[i] = padByte;
        }
        return byRet;
    }

    public static byte[] rightPad(byte[] bytes, int len, byte[] padBytes) {
        if (bytes == null || padBytes == null) {
            return bytes;
        }
        int srcLen = bytes.length;
        if (len <= srcLen) {
            return bytes;
        }
        byte[] byRet = new byte[len];
        System.arraycopy(bytes, 0, byRet, 0, srcLen);
        int padSzie = len - srcLen;
        int length = padBytes.length;
        int count = padSzie / length;
        for (int i = 0; i < count; ++i) {
            System.arraycopy(padBytes, 0, byRet, srcLen + i * length, length);
        }
        int surplus = padSzie % length;
        System.arraycopy(padBytes, 0, byRet, srcLen + count * length, surplus);
        return byRet;
    }

    public static byte[] short2byte(short shortData) {
        byte b1 = (byte)shortData;
        byte b0 = (byte)(shortData >> 8);
        return new byte[]{b0, b1};
    }

    private static int stringSize(int x) {
        int i = 0;
        while (x > SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static byte[] strip(byte[] bytes, byte stripByte) {
        byte[] byStart = ByteUtils.stripStart(bytes, stripByte);
        return ByteUtils.stripEnd(byStart, stripByte);
    }

    public static byte[] strip(byte[] bytes, byte[] stripArray) {
        byte[] byStart = ByteUtils.stripStart(bytes, stripArray);
        return ByteUtils.stripEnd(byStart, stripArray);
    }

    public static byte[] stripEnd(byte[] bytes, byte stripByte) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        int bySize = bytes.length;
        for (i = bySize - 1; i > 0 && bytes[i] == stripByte; --i) {
            if (bytes[i] != stripByte) continue;
            return new byte[0];
        }
        byte[] byRet = new byte[i + 1];
        System.arraycopy(bytes, 0, byRet, 0, i + 1);
        return byRet;
    }

    public static byte[] stripEnd(byte[] bytes, byte[] stripArray) {
        if (bytes == null || bytes.length == 0 || stripArray == null || stripArray.length == 0) {
            return bytes;
        }
        int bytesLength = bytes.length;
        int stripLength = stripArray.length;
        int i = bytesLength - 1;
        int index = ByteUtils.indexOf(stripArray, bytes[i]);
        if (index == -1) {
            return bytes;
        }
        int count = 0;
        for (int j = index; i >= 0 && j >= 0 && bytes[i] == stripArray[j]; --i, --j) {
            if (j != 0) continue;
            ++count;
            j = stripLength;
        }
        byte[] byRet = new byte[]{};
        if (count == 0) {
            return byRet;
        }
        int length = index + 1 + (count - 1) * stripLength;
        byRet = new byte[bytesLength - length];
        System.arraycopy(bytes, 0, byRet, 0, byRet.length);
        return byRet;
    }

    public static byte[] stripStart(byte[] bytes, byte stripByte) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        int bySize = bytes.length;
        for (i = 0; i < bySize && bytes[i] == stripByte; ++i) {
            if (i != bySize - 1 || bytes[i] != stripByte) continue;
            return new byte[0];
        }
        byte[] byRet = new byte[bySize - i];
        System.arraycopy(bytes, i, byRet, 0, bySize - i);
        return byRet;
    }

    public static byte[] stripStart(byte[] bytes, byte[] stripArray) {
        if (bytes == null || bytes.length == 0 || stripArray == null || stripArray.length == 0) {
            return bytes;
        }
        int bySize = bytes.length;
        int stripSize = stripArray.length;
        int i = 0;
        for (int j = 0; i < bySize && j < stripSize && bytes[i] == stripArray[j]; ++i, ++j) {
            if (j != stripSize - 1) continue;
            j = -1;
        }
        byte[] byRet = new byte[bySize - i];
        System.arraycopy(bytes, i, byRet, 0, bySize - i);
        return byRet;
    }

    public static byte[] stripZero(byte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        int startPos = 0;
        int endPos = bytes.length - 1;
        for (i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) {
                startPos = i;
                break;
            }
            if (i != bytes.length - 1 || bytes[i] != 0) continue;
            return new byte[0];
        }
        for (i = bytes.length - 1; i >= 0; --i) {
            if (bytes[i] != 0) {
                endPos = i;
                break;
            }
            if (i != 0) continue;
            return new byte[0];
        }
        byte[] byRet = new byte[endPos - startPos + 1];
        System.arraycopy(bytes, startPos, byRet, 0, endPos - startPos + 1);
        return byRet;
    }

    public static byte[] subBytes(byte[] srcData, int startPos, boolean startPosException, int length, boolean lengthException) {
        if (srcData == null) {
            throw new UtilRuntimeException(NULL_ARRAY_NOTSUPPORT_EX_MSG);
        }
        int srcLength = srcData.length;
        if (startPosException) {
            ByteUtils.validateStartPos(startPos, srcLength, startPos < 0 || startPos > srcLength, START_POS_MUST_LESS_THAN_SOURCE_LENGTH_EX_MSG);
        } else {
            if (startPos < 0) {
                startPos = 0;
            }
            if (startPos > srcLength) {
                return new byte[0];
            }
        }
        int surplus = srcLength - startPos;
        if (lengthException) {
            ByteUtils.validateStartPos(length, surplus, length < 0 || length > surplus, START_POS_MUST_LESS_THAN_SOURCE_LENGTH_EX_MSG);
        } else if (length < 0 || length > surplus) {
            length = surplus;
        }
        byte[] retArray = new byte[length];
        System.arraycopy(srcData, startPos, retArray, 0, length);
        return retArray;
    }

    private static void validateStartPos(int startPos, int srcLength, boolean b, String startPosMustLessThanSourceLengthExMsg) {
        if (b) {
            throw new UtilRuntimeException(String.format(startPosMustLessThanSourceLengthExMsg, startPos, srcLength));
        }
    }

    public static byte[] unicode2Asc(byte[] srcData, String encoding) throws IOException {
        ByteArrayOutputStream baos = null;
        boolean exist = false;
        int len = srcData.length;
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            if (i > len - 7 || srcData[i] != 38 || srcData[i + 1] != 35 || srcData[i + 7] != 59) continue;
            if (!exist) {
                baos = new ByteArrayOutputStream(len);
                exist = true;
            }
            baos.write(srcData, pos, i - pos);
            pos = i + 8;
            if (srcData[i + 2] == 120) {
                baos.write(ByteUtils.unicode2String(new String(srcData, i + 3, 4), true).getBytes(encoding));
            } else {
                baos.write(ByteUtils.unicode2String(new String(srcData, i + 2, 5), false).getBytes(encoding));
            }
            i += 7;
        }
        if (exist) {
            baos.write(srcData, pos, len - pos);
            return baos.toByteArray();
        }
        return srcData;
    }

    public static byte[] unicodeTransfer(byte[] data, String encoding) throws Exception {
        return ByteUtils.unicode2Asc(data, encoding);
    }

    public static String unicode2String(String unicodeCode, boolean hex) {
        if (hex) {
            return String.valueOf((char)Integer.parseInt(unicodeCode, 16));
        }
        return String.valueOf((char)Integer.parseInt(unicodeCode));
    }

    private static class IntegerArray {
        private byte[] byteArray;
        private int radix;
        private int result;
        private boolean negative;
        private int i;
        private int max;

        public IntegerArray(byte[] byteArray, int radix, int result, boolean negative, int i, int max) {
            this.byteArray = byteArray;
            this.radix = radix;
            this.result = result;
            this.negative = negative;
            this.i = i;
            this.max = max;
        }

        public int getResult() {
            return this.result;
        }

        public boolean isNegative() {
            return this.negative;
        }

        public int getI() {
            return this.i;
        }

        public IntegerArray invoke() {
            int digit;
            int limit;
            if (this.byteArray[0] == 45) {
                this.negative = true;
                limit = Integer.MIN_VALUE;
                ++this.i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / this.radix;
            if (this.i < this.max) {
                if ((digit = Character.digit(this.byteArray[this.i++], this.radix)) < 0) {
                    ByteUtils.convertDataIntEx(this.byteArray);
                } else {
                    this.result = -digit;
                }
            }
            while (this.i < this.max) {
                if ((digit = Character.digit(this.byteArray[this.i++], this.radix)) < 0) {
                    ByteUtils.convertDataIntEx(this.byteArray);
                }
                if (this.result < multmin) {
                    ByteUtils.convertDataIntEx(this.byteArray);
                }
                this.result *= this.radix;
                if (this.result < limit + digit) {
                    ByteUtils.convertDataIntEx(this.byteArray);
                }
                this.result -= digit;
            }
            return this;
        }
    }
}

