/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.utils;

import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class ExceptionUtils {
    public static final String BIZ_EXCEPTION = "BizException";
    private static final Logger log = LoggerFactory.getLogger(ExceptionUtils.class);

    private ExceptionUtils() {
        throw new IllegalStateException("static class should not have constructors");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getStackTraceInfo(Throwable exception) {
        try (StringWriter stringWriter = new StringWriter();){
            PrintWriter writer = new PrintWriter(stringWriter);
            try {
                exception.printStackTrace(writer);
                String string = stringWriter.getBuffer().toString();
                writer.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(ExceptionUtils.class).error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> String getExceptionInfo(T t, Function<T, Collection<String>> function) {
        Collection<String> infos = function.apply(t);
        return Objects.isNull(infos) || infos.isEmpty() ? null : infos.iterator().next();
    }

    @Nullable
    public static BizException tryFindYuspBizException(@Nullable Throwable exception) {
        if (Objects.isNull(exception)) {
            return null;
        }
        if (exception instanceof BizException) {
            return (BizException)exception;
        }
        Throwable cause = exception.getCause();
        if (null == cause) {
            return null;
        }
        return ExceptionUtils.tryFindYuspBizException(cause);
    }

    public static String tryFindYuspBizExceptionClassName(@NonNull Throwable exception) {
        return Optional.ofNullable(ExceptionUtils.tryFindYuspBizException(exception)).map(bizException -> bizException.getClass().getName()).orElse(exception.getClass().getName());
    }

    public static boolean isBizException(String exceptionClassName) {
        return null != exceptionClassName && exceptionClassName.endsWith(BIZ_EXCEPTION);
    }

    public static boolean isPlatformException(String exceptionClassName) {
        return PlatformException.class.getName().equals(exceptionClassName);
    }

    public static String getExceptionMessage(Throwable exception) {
        if (null == exception) {
            return null;
        }
        String message = exception.getMessage();
        if (null == message) {
            return ExceptionUtils.getExceptionMessage(exception.getCause());
        }
        return message;
    }

    public static Throwable getCauseException(Throwable exception) {
        if (null == exception) {
            return null;
        }
        Throwable cause = exception.getCause();
        if (null == cause) {
            return exception;
        }
        return ExceptionUtils.getCauseException(cause);
    }
}

