/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.util;

import java.util.ArrayList;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.ClassUtils;

public final class ProxyUtils {
    private ProxyUtils() {
    }

    public static Object proxy(Object target, Advice advice) {
        return ProxyUtils.proxy(target, advice, ClassUtils.getAllInterfaces((Object)target));
    }

    public static Object proxyMessageChannel(Object target, Advice advice) {
        ArrayList<Class<NamedComponent>> interfaces = new ArrayList<Class<NamedComponent>>();
        if (target instanceof MessageChannel) {
            interfaces.add(MessageChannel.class);
        }
        if (target instanceof SubscribableChannel) {
            interfaces.add(SubscribableChannel.class);
        }
        if (target instanceof NamedComponent) {
            interfaces.add(NamedComponent.class);
        }
        return ProxyUtils.proxy(target, advice, interfaces.toArray(new Class[0]));
    }

    public static Object proxy(Object target, Advice advice, Class<?>[] interfaces) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget(target);
        proxyFactory.setInterfaces(new Class[0]);
        proxyFactory.addAdvice(advice);
        proxyFactory.setInterfaces((Class[])interfaces);
        return proxyFactory.getProxy();
    }

    public static Class<?> getTargetClass(Object candidate) {
        return AopUtils.getTargetClass((Object)candidate);
    }

    public static <T> T getTarget(Object proxy, Class<T> targetClass) {
        if (targetClass.isAssignableFrom(ProxyUtils.getTargetClass(proxy))) {
            return (T)AopProxyUtils.getSingletonTarget((Object)proxy);
        }
        return null;
    }
}

