/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.util;

import cn.com.yusys.udp.cloud.message.exception.MessageException;
import cn.com.yusys.udp.cloud.message.persistent.constant.MessageType;
import cn.com.yusys.udp.cloud.message.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public final class MessageHeaderUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageHeaderUtils.class);

    private MessageHeaderUtils() {
    }

    public static <T> String serialize(T payload) {
        try {
            if (payload instanceof String) {
                return (String)payload;
            }
            if (payload instanceof byte[]) {
                log.debug("receive message, serial by new String(byte[]).");
                return new String((byte[])payload, StandardCharsets.UTF_8);
            }
            return ObjectMapperUtils.instance().writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new MessageException("Serialize payload exception.", e);
        }
    }

    public static String header(Message<?> message, @NotEmpty String header) {
        MessageHeaders headers = message.getHeaders();
        return Optional.ofNullable(StringUtils.utf8Str((Object)headers.get((Object)header))).orElseThrow(() -> new MessageException("Missing [" + header + "] Message Header"));
    }

    public static <T> T header(Message<?> message, @NotEmpty String header, Class<T> returnType, T defaultValue) {
        MessageHeaders headers = message.getHeaders();
        return (T)Optional.ofNullable(headers.get((Object)header, returnType)).orElse(defaultValue);
    }

    public static boolean persist(Message<?> message) {
        return MessageHeaderUtils.header(message, "persist", Boolean.class, true) != false && MessageHeaderUtils.notPublishSubscribable(MessageHeaderUtils.header(message, "eventName", String.class, ""));
    }

    public static boolean notPublishSubscribable(String event) {
        if (StringUtils.isEmpty((CharSequence)event)) {
            return true;
        }
        String[] words = event.split("\\.");
        if (words.length != 3) {
            return false;
        }
        String consumer = words[1];
        return !"all".equalsIgnoreCase(consumer);
    }

    public static String event(Message<?> message) {
        return MessageHeaderUtils.header(message, "eventName");
    }

    public static String msgId(Message<?> message) {
        return MessageHeaderUtils.header(message, "msgId");
    }

    public static String requestSeq(Message<?> message) {
        return MessageHeaderUtils.header(message, "requestSeq");
    }

    public static String bizSeq(Message<?> message) {
        return MessageHeaderUtils.header(message, "bizKey", String.class, "");
    }

    public static String manual(Message<?> message, String msgType) {
        String manualHeader = MessageHeaderUtils.manualHeader(msgType);
        return MessageHeaderUtils.header(message, manualHeader, String.class, "N");
    }

    public static String manualHeader(String msgType) {
        return MessageType.RECEIVE.getCode().equals(msgType) ? "C_RY_MANUAL" : "RY_MANUAL";
    }

    public static Integer retryTimes(Message<?> message, String msgType) {
        String messageHeader = MessageHeaderUtils.retryTimesHeader(msgType);
        return MessageHeaderUtils.header(message, messageHeader, Integer.class, 0);
    }

    public static String retryTimesHeader(String msgType) {
        return MessageType.RECEIVE.getCode().equals(msgType) ? "C_RY_TIMES" : "RY_TIMES";
    }
}

