/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.rule.publish;

import cn.com.yusys.udp.cloud.message.channel.ChannelRegistry;
import cn.com.yusys.udp.cloud.message.persistent.MessageSequenceHelper;
import cn.com.yusys.udp.cloud.message.rule.MessageEventBindingService;
import cn.com.yusys.udp.cloud.message.rule.MessageEventStrategy;
import cn.com.yusys.udp.cloud.message.rule.publish.MessageQueueHelper;
import cn.com.yusys.udp.cloud.message.util.ProxyUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.channel.AbstractSubscribableChannel;
import org.springframework.lang.NonNull;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;

public class BindingMessageQueueHelper
implements MessageQueueHelper,
ApplicationContextAware {
    private static final Object LOCK = new Object();
    private final Logger log = LoggerFactory.getLogger(BindingMessageQueueHelper.class);
    private MessageSequenceHelper builder;
    private MessageEventStrategy messageEventStrategy;
    private MessageEventBindingService messageEventBindingService;

    @Override
    public String resolveChannel(String event) {
        return this.messageEventStrategy.resolveChannel(event, true).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageChannel findOutputChannelByEvent(String event) {
        String channelName = this.resolveChannel(event);
        MessageChannel messageChannel = ChannelRegistry.output(channelName);
        if (this.determineChannelNeedBind(messageChannel)) {
            Object object = LOCK;
            synchronized (object) {
                messageChannel = ChannelRegistry.output(channelName);
                if (this.determineChannelNeedBind(messageChannel)) {
                    this.log.debug("event:[{}] dynamic create and bind channel:[{}].", (Object)event, (Object)channelName);
                    messageChannel = this.messageEventBindingService.createAndBindProducerByEvent(event, MessageChannel.class);
                } else {
                    this.log.debug("event:[{}] already exist channel:[{}].", (Object)event, (Object)channelName);
                }
            }
        }
        return messageChannel;
    }

    boolean determineChannelNeedBind(MessageChannel messageChannel) {
        if (messageChannel == null) {
            this.log.debug("Not exists channel.");
            return true;
        }
        AbstractSubscribableChannel sendChannel = ProxyUtils.getTarget(messageChannel, AbstractSubscribableChannel.class);
        if (Objects.nonNull(sendChannel)) {
            int count = sendChannel.getSubscriberCount();
            this.log.debug("exists channel, exist subscriber:{}.", (Object)count);
            return count == 0;
        }
        return false;
    }

    @Override
    public void fillMessageHeaders(String event, MessageBuilder<?> messageBuilder) {
        messageBuilder.setHeaderIfAbsent("persist", (Object)true);
        messageBuilder.setHeaderIfAbsent("msgId", (Object)this.builder.msgId());
        messageBuilder.setHeaderIfAbsent("requestSeq", (Object)this.builder.requestSeq());
        messageBuilder.setHeader("eventName", (Object)event);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        this.builder = (MessageSequenceHelper)applicationContext.getBean(MessageSequenceHelper.class);
        this.messageEventStrategy = (MessageEventStrategy)applicationContext.getBean(MessageEventStrategy.class);
        this.messageEventBindingService = (MessageEventBindingService)applicationContext.getBean(MessageEventBindingService.class);
    }
}

