/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.rule.impl;

import cn.com.yusys.udp.cloud.message.channel.factory.ChannelFactory;
import cn.com.yusys.udp.cloud.message.rule.MessageEventBindingService;
import cn.com.yusys.udp.cloud.message.rule.MessageEventStrategy;

public class MessageEventBindingServiceImpl
implements MessageEventBindingService {
    private final ChannelFactory channelFactory;
    private final MessageEventStrategy messageEventStrategy;

    public MessageEventBindingServiceImpl(ChannelFactory channelFactory, MessageEventStrategy messageEventStrategy) {
        this.channelFactory = channelFactory;
        this.messageEventStrategy = messageEventStrategy;
    }

    @Override
    public <T> T outputDeclareByEvent(String event, Class<T> channelClazz) {
        String channelName = this.messageEventStrategy.resolveChannel(event, true).getName();
        return this.outputDeclareByChannel(channelName, channelClazz);
    }

    @Override
    public <T> T outputDeclareByChannel(String channelName, Class<T> channelClazz) {
        return (T)this.channelFactory.outputDeclare(channelName, channelClazz);
    }

    @Override
    public <T> void bindProducerByEvent(String event, T channel) {
        String channelName = this.messageEventStrategy.resolveChannel(event, true).getName();
        this.messageEventStrategy.fillBindingRule(channelName, true);
        this.channelFactory.bindProducer(channel, channelName);
    }

    @Override
    public <T> T inputDeclareByChannel(String channelName, Class<T> channelClazz) {
        return (T)this.channelFactory.inputDeclare(channelName, channelClazz);
    }

    @Override
    public <T> void bindConsumerByChannel(String channelName, T channel) {
        this.messageEventStrategy.fillBindingRule(channelName, false);
        this.channelFactory.bindConsumer(channel, channelName);
    }
}

