/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.rabbit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.event.AmqpEvent;
import org.springframework.amqp.rabbit.listener.AsyncConsumerStartedEvent;
import org.springframework.amqp.rabbit.listener.ConsumeOkEvent;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerFailedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;

public class AmqpListener
implements ApplicationListener<AmqpEvent> {
    private static final Logger log = LoggerFactory.getLogger(AmqpListener.class);

    public void onApplicationEvent(@NonNull AmqpEvent event) {
        if (event instanceof ListenerContainerConsumerFailedEvent) {
            ListenerContainerConsumerFailedEvent consumerFailedEvent = (ListenerContainerConsumerFailedEvent)event;
            if (log.isErrorEnabled()) {
                log.error(String.format("Consumer Failure, fatal: [%s], reason: [%s].", consumerFailedEvent.isFatal(), consumerFailedEvent.getReason()), consumerFailedEvent.getThrowable());
            }
        } else if (event instanceof AsyncConsumerStartedEvent) {
            AsyncConsumerStartedEvent startedEvent = (AsyncConsumerStartedEvent)event;
            log.debug("Consumer:[{}] already started", startedEvent.getConsumer());
        } else if (event instanceof ConsumeOkEvent) {
            ConsumeOkEvent consumeOkEvent = (ConsumeOkEvent)event;
            log.debug("Queue:[{}] create consumer tag[{}]", (Object)consumeOkEvent.getQueue(), (Object)consumeOkEvent.getConsumerTag());
        } else {
            log.debug("listener amqp event:{}", (Object)event);
        }
    }
}

