/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.persistent;

import cn.com.yusys.udp.cloud.message.persistent.MessageStore;
import cn.com.yusys.udp.cloud.message.persistent.constant.MessageType;
import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

public class ConfirmChannel
implements MessageChannel {
    private static final Logger log = LoggerFactory.getLogger(ConfirmChannel.class);
    private final MessageStore messageStore;

    public ConfirmChannel(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public boolean send(@NonNull Message<?> message, long timeout) {
        log.debug("Send message success:{}.", message);
        if (MessageHeaderUtils.persist(message)) {
            String msgId = MessageHeaderUtils.msgId(message);
            log.debug("Update message status to send_success:{}.", (Object)msgId);
            this.messageStore.updateStatus(message, MessageType.SEND.getCode());
        }
        return true;
    }
}

