/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.memory;

import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHandlingRunnable;

public class MemoryExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(MemoryExecutor.class);
    private final ScheduledExecutorService executor;

    public MemoryExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command instanceof MessageHandlingRunnable) {
            MessageHandlingRunnable handlingRunnable = (MessageHandlingRunnable)command;
            Message message = handlingRunnable.getMessage();
            Long delay = MessageHeaderUtils.header(message, "delayMill", Long.class, 0L);
            log.debug("Memory queue\uff0cexecute after delay :{} milliseconds.", (Object)delay);
            this.executor.schedule(command, (long)delay, TimeUnit.MILLISECONDS);
        } else {
            this.executor.execute(command);
        }
    }
}

