/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.consumer.interceptor;

import cn.com.yusys.udp.cloud.message.consumer.MessageEventConfig;
import cn.com.yusys.udp.cloud.message.consumer.TransactionMessageEventDispatcher;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageEventInterceptor;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageInterceptorFactory;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.StoreMessageInterceptor;
import cn.com.yusys.udp.cloud.message.exception.MessageException;
import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import cn.com.yusys.udp.cloud.message.util.QueueAckUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class StoreMessageInterceptorFactory
implements MessageInterceptorFactory {
    private static final Logger log = LoggerFactory.getLogger(StoreMessageInterceptorFactory.class);
    private final TransactionMessageEventDispatcher transactionMessageEventDispatcher;

    public StoreMessageInterceptorFactory(TransactionMessageEventDispatcher transactionMessageEventDispatcher) {
        this.transactionMessageEventDispatcher = transactionMessageEventDispatcher;
    }

    @Override
    public MessageEventInterceptor create(MessageEventConfig messageEventConfig) {
        return new MaxStoreMessageInterceptor(this.transactionMessageEventDispatcher, messageEventConfig);
    }

    static class MaxStoreMessageInterceptor
    extends StoreMessageInterceptor {
        private String event;
        private final int maxConsumerTimes;
        private Map<String, Integer> consumerTimesMap = new ConcurrentHashMap<String, Integer>();

        public MaxStoreMessageInterceptor(TransactionMessageEventDispatcher transactionMessageEventDispatcher, MessageEventConfig eventConfig) {
            super(transactionMessageEventDispatcher);
            this.event = eventConfig.getEvent();
            this.maxConsumerTimes = eventConfig.getMaxConsumerTimes();
        }

        @Override
        protected void receiveExceptionHandle(Exception e, Message<?> message) {
            log.debug("Message consumer failure, reject message.");
            try {
                String msgId = MessageHeaderUtils.msgId(message);
                Integer consumerTimes = this.consumerTimesMap.getOrDefault(msgId, 0);
                if (log.isWarnEnabled()) {
                    log.warn("event:{},msg:{}, receive failure :{} times.", new Object[]{MessageHeaderUtils.event(message), msgId, consumerTimes});
                }
                if (consumerTimes >= this.getMaxConsumerTimes()) {
                    this.consumerTimesMap.remove(msgId);
                    QueueAckUtils.nack(message, false);
                    this.recordBizLog(e, message);
                } else {
                    Integer n = consumerTimes;
                    Integer n2 = consumerTimes = Integer.valueOf(consumerTimes + 1);
                    this.consumerTimesMap.put(msgId, consumerTimes);
                    QueueAckUtils.nack(message, true);
                }
            }
            catch (MessageException ex) {
                log.error("handle received failure, cause by:{}.", (Object)ex.getMessage());
            }
        }

        public int getMaxConsumerTimes() {
            return this.maxConsumerTimes;
        }
    }
}

