/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.consumer.interceptor;

import cn.com.yusys.udp.cloud.message.consumer.TransactionMessageEventDispatcher;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.AbstractMessageEventInterceptor;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageEventInterceptorChain;
import cn.com.yusys.udp.cloud.message.exception.PlatformException;
import cn.com.yusys.udp.cloud.message.util.QueueAckUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.messaging.Message;

public class StoreMessageInterceptor
extends AbstractMessageEventInterceptor
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(StoreMessageInterceptor.class);
    private final TransactionMessageEventDispatcher transactionMessageEventDispatcher;

    public StoreMessageInterceptor(TransactionMessageEventDispatcher transactionMessageEventDispatcher) {
        this.transactionMessageEventDispatcher = transactionMessageEventDispatcher;
    }

    @Override
    public void doHandle(Message<?> message, MessageEventInterceptorChain chain) throws PlatformException {
        this.receiveMessage(message);
        super.doHandle(message, chain);
    }

    void receiveMessage(Message<?> message) {
        try {
            log.debug("Receive Message From Broker, then record into Message_Center.");
            this.transactionMessageEventDispatcher.receiveMessage(message);
            this.successReceive(message);
        }
        catch (Exception e) {
            this.receiveExceptionHandle(e, message);
            throw e;
        }
    }

    protected void successReceive(Message<?> message) {
        log.debug("store db success,ack message.");
        QueueAckUtils.ack(message);
    }

    protected void receiveExceptionHandle(Exception e, Message<?> message) {
        log.debug("Message consumer failure, reject message.");
        this.recordBizLog(e, message);
        QueueAckUtils.nack(message, true);
    }

    protected void recordBizLog(Exception e, Message<?> message) {
        QueueAckUtils.recordBizLog(e, message);
    }

    public int getOrder() {
        return -2147483598;
    }
}

