/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.consumer.interceptor;

import cn.com.yusys.udp.cloud.message.consumer.MessageEventConfig;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.AbstractMessageEventInterceptor;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageEventInterceptor;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageEventInterceptorChain;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageInterceptorFactory;
import cn.com.yusys.udp.cloud.message.exception.MessageConsumerException;
import cn.com.yusys.udp.cloud.message.exception.PlatformException;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.messaging.Message;

public class ConcurrencyLimitInterceptorFactory
implements MessageInterceptorFactory {
    @Override
    public MessageEventInterceptor create(MessageEventConfig messageEventConfig) {
        return new ConcurrencyLimitInterceptor(messageEventConfig);
    }

    static class ConcurrencyLimitInterceptor
    extends AbstractMessageEventInterceptor
    implements Ordered {
        private static final Logger log = LoggerFactory.getLogger(ConcurrencyLimitInterceptor.class);
        private Semaphore semaphore;

        public ConcurrencyLimitInterceptor(MessageEventConfig eventConfig) {
            int concurrency = eventConfig.getConcurrency();
            if (concurrency > 0) {
                this.semaphore = new Semaphore(eventConfig.getConcurrency());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doHandle(Message<?> message, MessageEventInterceptorChain chain) throws PlatformException {
            if (this.semaphore != null) {
                log.debug("Exists concurrency limit, Attempt fetch token.");
                try {
                    this.semaphore.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw MessageConsumerException.create(e, "MQ_C_002", new Object[0]);
                }
                try {
                    super.doHandle(message, chain);
                }
                finally {
                    this.semaphore.release();
                }
            }
            super.doHandle(message, chain);
        }

        public int getOrder() {
            return 10;
        }
    }
}

