/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.config.rabbit;

import cn.com.yusys.udp.cloud.message.config.MessageAutoConfiguration;
import cn.com.yusys.udp.cloud.message.config.rabbit.RabbitPropertiesPostProcessor;
import cn.com.yusys.udp.cloud.message.persistent.ConfirmChannel;
import cn.com.yusys.udp.cloud.message.rabbit.AmqpListener;
import cn.com.yusys.udp.cloud.message.rabbit.ErrorChannel;
import cn.com.yusys.udp.cloud.message.util.SpringContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.config.BindingServiceConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={AmqpListener.class, ErrorChannel.class, ConfirmChannel.class})
@AutoConfigureAfter(value={MessageAutoConfiguration.class})
@AutoConfigureBefore(value={RabbitAutoConfiguration.class, BindingServiceConfiguration.class})
public class YuRabbitAutoConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(YuRabbitAutoConfiguration.class);
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    public AmqpListener amqpListener() {
        log.debug("Init Rabbit Event listener.");
        return new AmqpListener();
    }

    @Bean(value={"errorChannel"})
    @ConditionalOnMissingBean
    public ErrorChannel errorChannel() {
        log.debug("Init Default Error Channel.");
        return new ErrorChannel();
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitPropertiesPostProcessor rabbitPropertiesPostProcessor() {
        return new RabbitPropertiesPostProcessor();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        SpringContextUtils.initApplicationContextIfNotSet(applicationContext);
    }
}

