/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.config.memory;

import cn.com.yusys.udp.cloud.message.config.memory.MessageTaskProperties;
import cn.com.yusys.udp.cloud.message.memory.MemoryBinder;
import cn.com.yusys.udp.cloud.message.memory.MemoryExecutor;
import cn.com.yusys.udp.cloud.message.memory.MemoryProvisioningProvider;
import cn.com.yusys.udp.cloud.message.persistent.ConfirmChannel;
import cn.com.yusys.udp.cloud.message.util.BindingUtils;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@EnableConfigurationProperties(value={MessageTaskProperties.class})
public class MemoryBinderServiceAutoConfiguration {
    public static final String MEMORY_PROVIDER_NAME = "memoryProvider";

    @Bean(value={"memoryPoolExecutor"})
    public ScheduledExecutorService memoryPoolExecutor(MessageTaskProperties taskProperties) {
        return BindingUtils.getScheduledExecutorService("memory-send-", taskProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @DependsOn(value={"memoryPoolExecutor"})
    public MemoryExecutor messageExecutor(@Qualifier(value="memoryPoolExecutor") ScheduledExecutorService executorService) {
        return new MemoryExecutor(executorService);
    }

    @Bean
    @DependsOn(value={"memoryProvider"})
    public MemoryBinder memoryBinder(MemoryProvisioningProvider provisioningProvider, @Autowired(required=false) ConfirmChannel confirmChannel, MemoryExecutor executor) {
        return new MemoryBinder(new String[0], provisioningProvider, confirmChannel, executor);
    }

    @Bean(value={"memoryProvider"})
    public MemoryProvisioningProvider memoryProvider() {
        return new MemoryProvisioningProvider();
    }
}

