/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.config.event;

import cn.com.yusys.udp.cloud.message.channel.ChannelRegistry;
import cn.com.yusys.udp.cloud.message.config.event.MessageEventProperties;
import cn.com.yusys.udp.cloud.message.consumer.MessageEventConfig;
import cn.com.yusys.udp.cloud.message.consumer.MessageEventDispatcher;
import cn.com.yusys.udp.cloud.message.consumer.annotation.MessageEventComponent;
import cn.com.yusys.udp.cloud.message.consumer.annotation.MessageEventHandler;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.InterceptorChainProxy;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageEventInterceptor;
import cn.com.yusys.udp.cloud.message.consumer.interceptor.MessageInterceptorFactory;
import cn.com.yusys.udp.cloud.message.consumer.processor.MessageEventProcess;
import cn.com.yusys.udp.cloud.message.consumer.processor.MessageEventProcessFactory;
import cn.com.yusys.udp.cloud.message.listener.AbstractMessageEventHandler;
import cn.com.yusys.udp.cloud.message.rule.MessageEventBindingService;
import cn.com.yusys.udp.cloud.message.rule.MessageEventStrategy;
import cn.com.yusys.udp.cloud.message.util.BindingUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.ReflectionUtils;

public class MessageEventHandlerPostProcessor
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(MessageEventHandlerPostProcessor.class);
    private static final String EXECUTOR_SUFFIX = "-executor";
    private ConfigurableApplicationContext context;
    private MessageEventStrategy messageEventStrategy;
    private MessageEventBindingService messageEventBindingService;
    private MessageEventProperties messageEventProperties;
    private MessageEventProcessFactory messageEventProcessFactory;
    private List<MessageInterceptorFactory> factories;
    private List<MessageEventInterceptor> interceptors;

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        this.context = (ConfigurableApplicationContext)applicationContext;
        this.factories = applicationContext.getBeanProvider(MessageInterceptorFactory.class).orderedStream().collect(Collectors.toList());
        this.interceptors = applicationContext.getBeanProvider(MessageEventInterceptor.class).stream().collect(Collectors.toList());
    }

    public void afterSingletonsInstantiated() {
        this.initRequiredBean();
        this.initMessageEventDispatchers();
    }

    private void initMessageEventDispatchers() {
        Collection handlers = this.context.getBeansWithAnnotation(MessageEventComponent.class).values();
        HashMap<String, Map> channelMethodMap = new HashMap<String, Map>();
        handlers.forEach(handler -> this.resolveChannelMethod(handler, (Map<String, Map<String, InterceptorChainProxy>>)channelMethodMap));
        this.context.getBeansOfType(AbstractMessageEventHandler.class).forEach((name, eventHandler) -> this.resolveChannelMethod((AbstractMessageEventHandler<?>)eventHandler, (Map<String, Map<String, InterceptorChainProxy>>)channelMethodMap));
        channelMethodMap.forEach(this::initMessageEventDispatcher);
    }

    void resolveChannelMethod(AbstractMessageEventHandler<?> messageEventHandler, Map<String, Map<String, InterceptorChainProxy>> channelMethodMap) {
        String event = messageEventHandler.eventName();
        this.resolveChannelInternal(event, messageEventHandler.concurrentNum(), messageEventHandler, BeanUtils.findMethod(messageEventHandler.getClass(), (String)"handleMessage", (Class[])new Class[]{Object.class}), channelMethodMap);
    }

    void resolveChannelMethod(Object messageProcess, Map<String, Map<String, InterceptorChainProxy>> channelMethodMap) {
        Method[] uniqueDeclaredMethods;
        Class<?> targetClass = AopUtils.isAopProxy((Object)messageProcess) ? AopUtils.getTargetClass((Object)messageProcess) : messageProcess.getClass();
        for (Method method : uniqueDeclaredMethods = ReflectionUtils.getUniqueDeclaredMethods(targetClass)) {
            MessageEventHandler eventHandler = (MessageEventHandler)AnnotationUtils.findAnnotation((Method)method, MessageEventHandler.class);
            if (eventHandler == null || method.isBridge()) continue;
            String event = (String)AnnotationUtils.getValue((Annotation)eventHandler, (String)"value");
            this.resolveChannelInternal(event, eventHandler.concurrency(), messageProcess, method, channelMethodMap);
        }
    }

    void resolveChannelInternal(String event, int concurrency, Object messageProcess, Method method, Map<String, Map<String, InterceptorChainProxy>> channelMethodMap) {
        MessageEventStrategy.Channel channel = this.messageEventStrategy.resolveChannel(event, false);
        String channelName = channel.getName();
        Map chainMap = channelMethodMap.computeIfAbsent(channelName, name -> new HashMap());
        MessageEventConfig eventConfig = new MessageEventConfig();
        eventConfig.setEvent(event);
        eventConfig.setConcurrency(concurrency);
        MessageEventConfig config = this.messageEventProperties.getEvents().get(event);
        eventConfig.setMaxConsumerTimes(this.messageEventProperties.getMaxConsumerTimes());
        eventConfig = this.merge(eventConfig, config);
        chainMap.put(eventConfig.getEvent(), this.messageEventChain(messageProcess, method, eventConfig));
    }

    MessageEventConfig merge(MessageEventConfig origin, MessageEventConfig other) {
        if (Objects.isNull(other)) {
            return origin;
        }
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from((Object)other.getConcurrency()).whenNonNull().whenNot(param -> param == 0).to(origin::setConcurrency);
        propertyMapper.from((Object)other.getMaxConsumerTimes()).whenNonNull().whenNot(param -> param == 0).to(origin::setMaxConsumerTimes);
        return origin;
    }

    void initMessageEventDispatcher(String channelName, Map<String, InterceptorChainProxy> chains) {
        MessageEventDispatcher dispatcher = new MessageEventDispatcher(chains);
        Executor executor = this.initExecutor(channelName);
        Object executorProxy = this.context.getBeanFactory().initializeBean((Object)executor, channelName + EXECUTOR_SUFFIX);
        dispatcher.setExecutor((Executor)executorProxy);
        SubscribableChannel subscribableChannel = this.messageEventBindingService.inputDeclareByChannel(channelName, SubscribableChannel.class);
        subscribableChannel.subscribe((MessageHandler)dispatcher);
        log.debug("add subscribe handler to message channel: {}.", (Object)channelName);
        this.messageEventStrategy.fillBindingRule(channelName, false);
        ChannelRegistry.registerDynamicInput(channelName, subscribableChannel);
    }

    Executor initExecutor(String channelName) {
        return BindingUtils.getExecutorService(channelName, this.messageEventProperties.getConsumer());
    }

    private InterceptorChainProxy messageEventChain(Object bean, Method method, MessageEventConfig eventConfig) {
        MessageEventProcess messageEventProcess = this.messageEventProcessFactory.create(bean, method, eventConfig);
        List<MessageEventInterceptor> allInterceptors = this.factories.stream().map(factory -> factory.create(eventConfig)).collect(Collectors.toList());
        allInterceptors.addAll(this.interceptors);
        AnnotationAwareOrderComparator.sort(allInterceptors);
        return new InterceptorChainProxy(allInterceptors, messageEventProcess);
    }

    void initRequiredBean() {
        this.messageEventStrategy = (MessageEventStrategy)this.context.getBean(MessageEventStrategy.class);
        this.messageEventBindingService = (MessageEventBindingService)this.context.getBean(MessageEventBindingService.class);
        this.messageEventProperties = (MessageEventProperties)this.context.getBean(MessageEventProperties.class);
        this.messageEventProcessFactory = (MessageEventProcessFactory)this.context.getBean(MessageEventProcessFactory.class);
    }
}

