/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.config.event;

import cn.com.yusys.udp.cloud.message.channel.ChannelRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.messaging.SubscribableChannel;

public class DynamicBindable
implements Bindable {
    private static final Logger log = LoggerFactory.getLogger(DynamicBindable.class);

    public Collection<Binding<Object>> createAndBindInputs(BindingService adapter) {
        ArrayList<Binding<Object>> bindings = new ArrayList<Binding<Object>>();
        Map<String, SubscribableChannel> needBindInputs = ChannelRegistry.dynamicInputs();
        if (log.isDebugEnabled()) {
            log.debug("Bind dynamic inputs:{}.", needBindInputs.keySet());
        }
        needBindInputs.forEach((name, channel) -> bindings.addAll(adapter.bindConsumer(channel, name)));
        return bindings;
    }

    public void unbindInputs(BindingService adapter) {
        if (Objects.nonNull(adapter)) {
            ChannelRegistry.dynamicInputs().keySet().forEach(arg_0 -> ((BindingService)adapter).unbindConsumers(arg_0));
        }
    }
}

