/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.config;

import cn.com.yusys.udp.cloud.message.constant.MessageConstants;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class BindingEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(BindingEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, Object> messageMapping;
        MapPropertySource propertySource;
        boolean exists = environment.getPropertySources().contains("YuMessagePropertySources");
        if (exists) {
            propertySource = (MapPropertySource)environment.getPropertySources().get("YuMessagePropertySources");
            Objects.requireNonNull(propertySource, "propertySource is null");
            messageMapping = (Map)propertySource.getSource();
        } else {
            messageMapping = new HashMap();
            propertySource = new MapPropertySource("YuMessagePropertySources", messageMapping);
        }
        String appName = environment.getProperty("spring.application.name");
        if (StringUtils.nonEmpty((CharSequence)appName) && !environment.containsProperty("spring.cloud.stream.default.group")) {
            messageMapping.put("spring.cloud.stream.default.group", appName);
        }
        this.putIfAbsent((Environment)environment, messageMapping, "spring.cloud.stream.default.producer.error-channel-enabled", true);
        this.putIfAbsent((Environment)environment, messageMapping, "spring.cloud.stream.rabbit.default.producer.confirm-ack-channel", "confirmChannel");
        this.putIfAbsent((Environment)environment, messageMapping, "spring.cloud.stream.rabbit.default.consumer.acknowledge-mode", AcknowledgeMode.MANUAL);
        this.putIfAbsent((Environment)environment, messageMapping, "spring.cloud.stream.default-binder", "rabbit-broker");
        this.configureDlqQueue((Environment)environment, messageMapping);
        this.putIfAbsent((Environment)environment, messageMapping, "spring.sleuth.integration.patterns", MessageConstants.MSG_TRACE_CHANNELS);
        if (!exists) {
            log.debug("Add Custom global message properties:{}", messageMapping);
            environment.getPropertySources().addLast((PropertySource)propertySource);
        }
    }

    void configureDlqQueue(Environment environment, Map<String, Object> properties) {
        this.putIfAbsent(environment, properties, "spring.cloud.stream.rabbit.default.consumer.auto-bind-dlq", true);
        this.putIfAbsent(environment, properties, "spring.cloud.stream.rabbit.default.consumer.dlq-dead-letter-exchange", "udp-errors");
        this.putIfAbsent(environment, properties, "spring.cloud.stream.rabbit.default.consumer.dead-letter-exchange", "udp-errors");
        this.putIfAbsent(environment, properties, "spring.cloud.stream.rabbit.default.consumer.dead-letter-queue-name", "udp-errors.dlq");
        this.putIfAbsent(environment, properties, "spring.cloud.stream.rabbit.default.consumer.republish_to_dlq", true);
    }

    void putIfAbsent(Environment environment, Map<String, Object> properties, String key, Object value) {
        if (!environment.containsProperty(key)) {
            log.debug("Set environment [{}={}}].", (Object)key, value);
            properties.put(key, value);
        }
    }
}

