/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.channel.factory;

import cn.com.yusys.udp.cloud.message.channel.factory.ChannelFactory;
import cn.com.yusys.udp.cloud.message.util.BindingUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.BindingTargetFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.NonNull;

public class BindingChannelFactory
implements ChannelFactory,
ApplicationContextAware,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(BindingChannelFactory.class);
    private final Map<String, Binding<?>> outputBindings = new ConcurrentHashMap();
    private final Map<String, Binding<?>> inputBindings = new ConcurrentHashMap();
    private final Object producerLock = new Object();
    private final Object consumerLock = new Object();
    private ApplicationContext applicationContext;
    private BindingService bindingService;
    private Map<String, BindingTargetFactory> bindingTargetFactories;
    private volatile boolean running;

    @Override
    public <T> Object outputDeclare(String outputName, Class<T> clz) {
        if (this.applicationContext.containsBean(outputName)) {
            return this.applicationContext.getBean(outputName, clz);
        }
        this.checkBindingTargetFactory();
        BindingTargetFactory bindingTargetFactory = BindingUtils.getBindingTargetFactory(clz, this.bindingTargetFactories);
        return bindingTargetFactory.createOutput(outputName);
    }

    @Override
    public <T> Object inputDeclare(String inputName, Class<T> clz) {
        if (this.applicationContext.containsBean(inputName)) {
            return this.applicationContext.getBean(inputName, clz);
        }
        this.checkBindingTargetFactory();
        BindingTargetFactory bindingTargetFactory = BindingUtils.getBindingTargetFactory(clz, this.bindingTargetFactories);
        return bindingTargetFactory.createInput(inputName);
    }

    private void checkBindingTargetFactory() {
        if (this.bindingTargetFactories != null) {
            return;
        }
        this.bindingTargetFactories = this.applicationContext.getBeansOfType(BindingTargetFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void bindProducer(T output, String outputName) {
        Binding<?> binding = this.outputBindings.get(outputName);
        if (binding != null) {
            log.debug("Channel already bind,must unbind before rebind");
        } else {
            log.debug("Begin bind producer :{}", (Object)outputName);
            this.checkBindingService();
            Object object = this.producerLock;
            synchronized (object) {
                this.outputBindings.putIfAbsent(outputName, this.bindingService.bindProducer(output, outputName));
            }
        }
    }

    private void checkBindingService() {
        if (this.bindingService != null) {
            return;
        }
        this.bindingService = (BindingService)this.applicationContext.getBean(BindingService.class);
    }

    @Override
    public void unbindProducer(String outputName) {
        Binding<?> binding = this.outputBindings.remove(outputName);
        if (binding != null) {
            log.debug("unbind channel :{}", (Object)outputName);
            this.bindingService.unbindProducers(outputName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void bindConsumer(T input, String inputName) {
        Binding<?> binding = this.inputBindings.get(inputName);
        if (binding != null) {
            log.debug("Channel already bind,must unbind before rebind");
        } else {
            log.debug("Begin bind consumer :{}", (Object)inputName);
            this.checkBindingService();
            Object object = this.consumerLock;
            synchronized (object) {
                Collection bindings = this.bindingService.bindConsumer(input, inputName);
                bindings.forEach(bind -> this.inputBindings.putIfAbsent(inputName, (Binding<?>)bind));
            }
        }
    }

    @Override
    public void unbindConsumer(String inputName) {
        Binding<?> binding = this.inputBindings.remove(inputName);
        if (binding != null) {
            log.debug("unbind channel :{}", (Object)inputName);
            this.bindingService.unbindConsumers(inputName);
        }
    }

    public void start() {
        if (!this.running) {
            log.debug("Channel Factory begin Running.");
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            this.outputBindings.values().forEach(Binding::unbind);
            this.inputBindings.values().forEach(Binding::unbind);
            log.debug("Channel Factory finish Running.");
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setApplicationContext(@NonNull ApplicationContext context) {
        this.applicationContext = context;
    }
}

