/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.broker.impl;

import cn.com.yusys.udp.cloud.message.broker.RabbitBrokersChannelHelper;
import cn.com.yusys.udp.cloud.message.channel.factory.ChannelFactory;
import cn.com.yusys.udp.cloud.message.util.MessageHeaderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;

public class DefaultRabbitBrokersChannelHelper
implements RabbitBrokersChannelHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultRabbitBrokersChannelHelper.class);
    private static final String BROKER_SPLIT = "-";
    private final Map<String, Map<String, MessageChannel>> channels = new HashMap<String, Map<String, MessageChannel>>();
    private final List<String> brokers;
    private final ChannelFactory channelFactory;

    public DefaultRabbitBrokersChannelHelper(Set<String> brokers, ChannelFactory channelFactory) {
        this.brokers = new ArrayList<String>(brokers);
        this.channelFactory = channelFactory;
    }

    @Override
    public Map<String, MessageChannel> outputBrokerChannels(MessageChannel output) {
        Map<String, MessageChannel> brokerChannels = this.brokerChannelsInternal(output, channelName -> (MessageChannel)this.channelFactory.outputDeclare((String)channelName, MessageChannel.class));
        SubscribableChannel subscribableChannel = (SubscribableChannel)output;
        subscribableChannel.subscribe((MessageHandler)new SendRouteMessageHandler(brokerChannels));
        return brokerChannels;
    }

    @Override
    public Map<String, MessageChannel> inputBrokerChannels(MessageChannel input) {
        Map<String, MessageChannel> brokerChannels = this.brokerChannelsInternal(input, channelName -> (SubscribableChannel)this.channelFactory.inputDeclare((String)channelName, SubscribableChannel.class));
        brokerChannels.forEach((brokerName, channel) -> ((SubscribableChannel)channel).subscribe(message -> {
            log.debug("receive message form broker:{}", brokerName);
            input.send(message);
        }));
        return brokerChannels;
    }

    Map<String, MessageChannel> brokerChannelsInternal(MessageChannel channel, Function<String, ? extends MessageChannel> channelDeclare) {
        String channelName = this.getChannelName(channel);
        if (this.channels.containsKey(channelName)) {
            return this.channels.get(channelName);
        }
        HashMap<String, MessageChannel> messageChannels = new HashMap<String, MessageChannel>();
        this.brokers.forEach(broker -> messageChannels.put((String)broker, (MessageChannel)channelDeclare.apply(this.getBrokerChannelName(channelName, (String)broker))));
        this.channels.put(channelName, messageChannels);
        return messageChannels;
    }

    protected String getChannelName(MessageChannel channel) {
        return ((NamedComponent)channel).getBeanName();
    }

    protected String getBrokerChannelName(String channelName, String brokerName) {
        return "virtual-" + channelName + BROKER_SPLIT + brokerName;
    }

    class SendRouteMessageHandler
    implements MessageHandler {
        private final Map<String, MessageChannel> brokerChannels;

        public SendRouteMessageHandler(Map<String, MessageChannel> brokerChannels) {
            this.brokerChannels = brokerChannels;
        }

        public void handleMessage(@NonNull Message<?> message) {
            log.debug("Begin Send Message With BrokerChannels.");
            String eventName = MessageHeaderUtils.event(message);
            MessageChannel channel = this.choose(eventName);
            channel.send(message);
        }

        MessageChannel choose(String eventName) {
            int length = DefaultRabbitBrokersChannelHelper.this.brokers.size();
            int index = Math.abs(eventName.hashCode() % length);
            String broker = (String)DefaultRabbitBrokersChannelHelper.this.brokers.get(index);
            log.info("Choose Send Message broker\uff1a{}", (Object)broker);
            return this.brokerChannels.get(broker);
        }
    }
}

