/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.broker.impl;

import cn.com.yusys.udp.cloud.message.broker.RabbitConnectionFactoryCreator;
import cn.com.yusys.udp.cloud.message.broker.config.RabbitBrokerProperties;
import cn.com.yusys.udp.cloud.message.exception.MessageException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.lang.Nullable;

public class CachingRabbitConnectionFactoryCreator
implements RabbitConnectionFactoryCreator {
    @Override
    public ConnectionFactory createConnectionFactory(String brokerName, RabbitBrokerProperties rabbitBrokerProperties) {
        PropertyMapper map = PropertyMapper.get();
        CachingConnectionFactory factory = null;
        try {
            factory = new CachingConnectionFactory(Objects.requireNonNull((com.rabbitmq.client.ConnectionFactory)this.getRabbitConnectionFactoryBean(rabbitBrokerProperties).getObject()));
        }
        catch (Exception e) {
            throw new MessageException("Init connection factory failed.", e);
        }
        map.from(() -> ((RabbitBrokerProperties)rabbitBrokerProperties).determineAddresses()).to(arg_0 -> ((CachingConnectionFactory)factory).setAddresses(arg_0));
        map.from(() -> ((RabbitBrokerProperties)rabbitBrokerProperties).getPublisherConfirmType()).to(arg_0 -> ((CachingConnectionFactory)factory).setPublisherConfirmType(arg_0));
        map.from(() -> ((RabbitBrokerProperties)rabbitBrokerProperties).isPublisherReturns()).to(arg_0 -> ((CachingConnectionFactory)factory).setPublisherReturns(arg_0));
        RabbitProperties.Cache.Channel channel = rabbitBrokerProperties.getCache().getChannel();
        map.from(() -> ((RabbitProperties.Cache.Channel)channel).getSize()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setChannelCacheSize(arg_0));
        map.from(() -> ((RabbitProperties.Cache.Channel)channel).getCheckoutTimeout()).whenNonNull().as(Duration::toMillis).to(arg_0 -> ((CachingConnectionFactory)factory).setChannelCheckoutTimeout(arg_0));
        RabbitProperties.Cache.Connection connection = rabbitBrokerProperties.getCache().getConnection();
        map.from(() -> ((RabbitProperties.Cache.Connection)connection).getMode()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setCacheMode(arg_0));
        map.from(() -> ((RabbitProperties.Cache.Connection)connection).getSize()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionCacheSize(arg_0));
        map.from((Object)this.connectionNameStrategy(rabbitBrokerProperties)).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionNameStrategy(arg_0));
        map.from((Object)rabbitBrokerProperties.getConnectionLimit()).whenNonNull().to(arg_0 -> ((CachingConnectionFactory)factory).setConnectionLimit(arg_0));
        return factory;
    }

    private RabbitConnectionFactoryBean getRabbitConnectionFactoryBean(RabbitProperties properties) {
        PropertyMapper map = PropertyMapper.get();
        RabbitConnectionFactoryBean factory = new RabbitConnectionFactoryBean();
        map.from(() -> ((RabbitProperties)properties).determineHost()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setHost(arg_0));
        map.from(() -> ((RabbitProperties)properties).determinePort()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPort(arg_0));
        map.from(() -> ((RabbitProperties)properties).determineUsername()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setUsername(arg_0));
        map.from(() -> ((RabbitProperties)properties).determinePassword()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPassword(arg_0));
        map.from(() -> ((RabbitProperties)properties).determineVirtualHost()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setVirtualHost(arg_0));
        map.from(() -> ((RabbitProperties)properties).getRequestedHeartbeat()).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setRequestedHeartbeat(arg_0));
        RabbitProperties.Ssl ssl = properties.getSsl();
        if (null != ssl.getEnabled() && ssl.getEnabled().booleanValue()) {
            factory.setUseSSL(true);
            map.from(() -> ((RabbitProperties.Ssl)ssl).getAlgorithm()).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setSslAlgorithm(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getKeyStoreType()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStoreType(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getKeyStore()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStore(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getKeyStorePassword()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStorePassphrase(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getTrustStoreType()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStoreType(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getTrustStore()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStore(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getTrustStorePassword()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStorePassphrase(arg_0));
            map.from(() -> ((RabbitProperties.Ssl)ssl).isValidateServerCertificate()).to(validate -> factory.setSkipServerCertificateValidation(validate == false));
            map.from(() -> ((RabbitProperties.Ssl)ssl).getVerifyHostname()).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setEnableHostnameVerification(arg_0));
        }
        map.from(() -> ((RabbitProperties)properties).getConnectionTimeout()).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setConnectionTimeout(arg_0));
        factory.afterPropertiesSet();
        return factory;
    }

    @Nullable
    private ConnectionNameStrategy connectionNameStrategy(RabbitBrokerProperties rabbitBrokerProperties) {
        String namePrefix = rabbitBrokerProperties.getConnectionNamePrefix();
        if (StringUtils.isEmpty((CharSequence)namePrefix)) {
            return null;
        }
        AtomicInteger nameIncrementer = new AtomicInteger();
        return f -> namePrefix + "#" + nameIncrementer.getAndIncrement();
    }
}

