/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.broker.config;

import cn.com.yusys.udp.cloud.message.broker.ConnectionFactoryListener;
import cn.com.yusys.udp.cloud.message.broker.RabbitBrokersChannelHelper;
import cn.com.yusys.udp.cloud.message.broker.RabbitConnectionFactoryCreator;
import cn.com.yusys.udp.cloud.message.broker.binder.RabbitBrokersBinder;
import cn.com.yusys.udp.cloud.message.broker.config.RabbitBrokersProperties;
import cn.com.yusys.udp.cloud.message.broker.health.RabbitBrokersHealthIndicator;
import cn.com.yusys.udp.cloud.message.broker.impl.CachingRabbitConnectionFactoryCreator;
import cn.com.yusys.udp.cloud.message.broker.impl.DefaultRabbitBrokersChannelHelper;
import cn.com.yusys.udp.cloud.message.channel.factory.ChannelFactory;
import cn.com.yusys.udp.cloud.message.exception.MessageException;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Import(value={RabbitBrokersHealthIndicatorConfiguration.class})
@EnableConfigurationProperties(value={RabbitBrokersProperties.class, RabbitExtendedBindingProperties.class})
public class RabbitBrokersServiceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RabbitConnectionFactoryCreator rabbitConnectionFactoryCreator() {
        return new CachingRabbitConnectionFactoryCreator();
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitBrokersChannelHelper defaultRabbitBrokersChannelHelper(RabbitBrokersProperties rabbitBrokersProperties, ChannelFactory channelFactory) {
        return new DefaultRabbitBrokersChannelHelper(rabbitBrokersProperties.getBrokers().keySet(), channelFactory);
    }

    @Bean
    public RabbitBrokersBinder rabbitBrokersBinder(RabbitBrokersProperties rabbitBrokersProperties, RabbitExtendedBindingProperties extendedBindingProperties, ObjectProvider<ListenerContainerCustomizer<MessageListenerContainer>> listenerContainerCustomizers, RabbitBrokersChannelHelper rabbitBrokersChannelHelper, RabbitConnectionFactoryCreator rabbitConnectionFactoryCreator, ObjectProvider<List<ConnectionFactoryListener>> listenerProvider) {
        if (CollectionUtils.isEmpty(rabbitBrokersProperties.getBrokers())) {
            throw new MessageException("miss rabbit brokers configure.");
        }
        return new RabbitBrokersBinder(rabbitBrokersProperties, extendedBindingProperties, (ListenerContainerCustomizer<MessageListenerContainer>)((ListenerContainerCustomizer)listenerContainerCustomizers.getIfAvailable()), rabbitBrokersChannelHelper, rabbitConnectionFactoryCreator, (List)listenerProvider.getIfAvailable(ArrayList::new));
    }

    @Configuration
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
    static class RabbitBrokersHealthIndicatorConfiguration {
        RabbitBrokersHealthIndicatorConfiguration() {
        }

        @Bean
        public RabbitBrokersHealthIndicator rabbitBrokersHealthIndicator() {
            return new RabbitBrokersHealthIndicator();
        }
    }
}

