/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.broker.binder;

import cn.com.yusys.udp.cloud.message.broker.ConnectionFactoryListener;
import cn.com.yusys.udp.cloud.message.broker.RabbitBrokersChannelHelper;
import cn.com.yusys.udp.cloud.message.broker.RabbitConnectionFactoryCreator;
import cn.com.yusys.udp.cloud.message.broker.binder.AbstractRabbitExtendBinder;
import cn.com.yusys.udp.cloud.message.broker.binder.RabbitBrokerBinding;
import cn.com.yusys.udp.cloud.message.broker.config.RabbitBrokerProperties;
import cn.com.yusys.udp.cloud.message.broker.config.RabbitBrokersProperties;
import cn.com.yusys.udp.cloud.message.exception.MessageException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.support.postprocessor.DelegatingDecompressingPostProcessor;
import org.springframework.amqp.support.postprocessor.GZipPostProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.rabbit.RabbitMessageChannelBinder;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitProducerProperties;
import org.springframework.cloud.stream.binder.rabbit.provisioning.RabbitExchangeQueueProvisioner;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.SpelExpressionConverterConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.lang.NonNull;
import org.springframework.messaging.MessageChannel;

public class RabbitBrokersBinder
extends AbstractRabbitExtendBinder
implements InitializingBean,
ApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(RabbitBrokersBinder.class);
    private final Map<String, RabbitMessageChannelBinder> binders = new HashMap<String, RabbitMessageChannelBinder>();
    private final RabbitBrokersProperties rabbitBrokersProperties;
    private final ListenerContainerCustomizer<MessageListenerContainer> listenerContainerCustomizer;
    private final RabbitBrokersChannelHelper rabbitBrokersChannelHelper;
    private final RabbitConnectionFactoryCreator rabbitConnectionFactoryCreator;
    private final List<ConnectionFactoryListener> connectionFactoryListeners;

    public RabbitBrokersBinder(RabbitBrokersProperties rabbitBrokersProperties, RabbitExtendedBindingProperties extendedBindingProperties, ListenerContainerCustomizer<MessageListenerContainer> listenerContainerCustomizer, RabbitBrokersChannelHelper rabbitBrokersChannelHelper, RabbitConnectionFactoryCreator rabbitConnectionFactoryCreator, List<ConnectionFactoryListener> connectionFactoryListeners) {
        super(extendedBindingProperties);
        this.rabbitBrokersProperties = rabbitBrokersProperties;
        this.listenerContainerCustomizer = listenerContainerCustomizer;
        this.rabbitBrokersChannelHelper = rabbitBrokersChannelHelper;
        this.rabbitConnectionFactoryCreator = rabbitConnectionFactoryCreator;
        this.connectionFactoryListeners = connectionFactoryListeners;
        this.initBinders();
    }

    private void initBinders() {
        this.rabbitBrokersProperties.getBrokers().forEach(this::initBinder);
    }

    protected void initBinder(String brokerName, RabbitBrokerProperties brokerProperties) {
        this.log.debug("Begin Init broker[{}] RabbitBinder.", (Object)brokerName);
        this.log.debug("Begin Init broker[{}] ConnectionFactory.", (Object)brokerName);
        ConnectionFactory connectionFactory = this.initConnectionFactory(brokerName, brokerProperties);
        this.connectionFactoryListeners.forEach(listener -> listener.onCreate(brokerName, connectionFactory));
        this.log.debug("End Init broker[{}] ConnectionFactory.", (Object)brokerName);
        RabbitMessageChannelBinder rabbitMessageChannelBinder = this.initBinder(connectionFactory, brokerProperties);
        this.binders.put(brokerName, rabbitMessageChannelBinder);
        this.log.debug("End Init broker[{}] RabbitBinder.", (Object)brokerName);
    }

    private ConnectionFactory initConnectionFactory(String brokerName, RabbitBrokerProperties brokerProperties) {
        try {
            return this.rabbitConnectionFactoryCreator.createConnectionFactory(brokerName, brokerProperties);
        }
        catch (Exception e) {
            throw new MessageException("Create Rabbit ConnectionFactory failure", e);
        }
    }

    private RabbitMessageChannelBinder initBinder(ConnectionFactory connectionFactory, RabbitBrokerProperties brokerProperties) {
        RabbitMessageChannelBinder binder = new RabbitMessageChannelBinder(connectionFactory, (RabbitProperties)brokerProperties, this.provisioningProvider(connectionFactory), this.listenerContainerCustomizer);
        binder.setAdminAddresses(brokerProperties.getAdminAddresses());
        binder.setCompressingPostProcessor(this.gZipPostProcessor(brokerProperties));
        binder.setDecompressingPostProcessor(this.deCompressingPostProcessor());
        binder.setNodes(brokerProperties.getNodes());
        binder.setExtendedBindingProperties(this.getExtendedBindingProperties());
        return binder;
    }

    RabbitExchangeQueueProvisioner provisioningProvider(ConnectionFactory connectionFactory) {
        return new RabbitExchangeQueueProvisioner(connectionFactory);
    }

    MessagePostProcessor gZipPostProcessor(RabbitBrokerProperties brokerProperties) {
        GZipPostProcessor gZipPostProcessor = new GZipPostProcessor();
        gZipPostProcessor.setLevel(brokerProperties.getCompressionLevel());
        return gZipPostProcessor;
    }

    MessagePostProcessor deCompressingPostProcessor() {
        return new DelegatingDecompressingPostProcessor();
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        this.binders.values().forEach(binder -> binder.setApplicationContext(this.wrap(applicationContext)));
        super.setApplicationContext(applicationContext);
    }

    private ApplicationContext wrap(ApplicationContext applicationContext) {
        this.log.debug("Wrap Binder Context.");
        SpringApplicationBuilder binderContextBuilder = new SpringApplicationBuilder(new Class[]{SpelExpressionConverterConfiguration.class}).bannerMode(Banner.Mode.OFF).logStartupInfo(false).web(WebApplicationType.NONE);
        binderContextBuilder.parent((ConfigurableApplicationContext)applicationContext);
        Environment environment = applicationContext.getEnvironment();
        StandardEnvironment binderEnvironment = new StandardEnvironment();
        binderEnvironment.merge((ConfigurableEnvironment)environment);
        binderEnvironment.getPropertySources().remove("configurationProperties");
        binderContextBuilder.environment((ConfigurableEnvironment)binderEnvironment);
        return binderContextBuilder.run(new String[0]);
    }

    protected Binding<MessageChannel> doBindConsumer(String name, String group, MessageChannel inputTarget, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        HashMap<String, Binding<MessageChannel>> bindings = new HashMap<String, Binding<MessageChannel>>();
        this.log.debug("Fetch input channel related broker input channel.");
        Map<String, MessageChannel> channels = this.rabbitBrokersChannelHelper.inputBrokerChannels(inputTarget);
        this.binders.forEach((broker, binder) -> bindings.put((String)broker, this.bindInput((String)broker, name, group, (RabbitMessageChannelBinder)binder, (Map<String, ? extends MessageChannel>)channels, properties)));
        return new RabbitBrokerBinding(name, bindings, true);
    }

    Binding<MessageChannel> bindInput(String brokerName, String name, String group, RabbitMessageChannelBinder binder, Map<String, ? extends MessageChannel> inputChannels, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        this.log.debug("Begin Bind broker:{} input channel with destination:{},group:{}.", new Object[]{brokerName, name, group});
        return binder.bindConsumer(name, group, (Object)inputChannels.get(brokerName), properties);
    }

    protected Binding<MessageChannel> doBindProducer(String name, MessageChannel outboundBindTarget, ExtendedProducerProperties<RabbitProducerProperties> properties) {
        HashMap<String, Binding<MessageChannel>> bindings = new HashMap<String, Binding<MessageChannel>>();
        this.log.debug("Fetch output channel related broker output channel.");
        Map<String, MessageChannel> outputChannels = this.rabbitBrokersChannelHelper.outputBrokerChannels(outboundBindTarget);
        this.binders.forEach((brokerName, binder) -> bindings.put((String)brokerName, this.bindOutput((String)brokerName, name, (RabbitMessageChannelBinder)binder, (Map<String, ? extends MessageChannel>)outputChannels, properties)));
        return new RabbitBrokerBinding(name, bindings, false);
    }

    Binding<MessageChannel> bindOutput(String brokerName, String name, RabbitMessageChannelBinder binder, Map<String, ? extends MessageChannel> outputChannels, ExtendedProducerProperties<RabbitProducerProperties> properties) {
        this.log.debug("Begin Bind broker:{} output channel with destination:{}.", (Object)brokerName, (Object)name);
        return binder.bindProducer(name, (Object)outputChannels.get(brokerName), properties);
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.binders.values().forEach(binder -> {
            try {
                binder.onInit();
            }
            catch (Exception e) {
                this.log.error("init binder failure,", (Throwable)e);
            }
        });
    }
}

