/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message.broker.binder;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.messaging.MessageChannel;

public class RabbitBrokerBinding
implements Binding<MessageChannel> {
    private final String name;
    private final Map<String, Binding<MessageChannel>> bindings;
    private final boolean input;

    public RabbitBrokerBinding(String name, Map<String, Binding<MessageChannel>> bindings, boolean input) {
        this.name = name;
        this.bindings = bindings;
        this.input = input;
    }

    public Map<String, Object> getExtendedInfo() {
        return this.bindings.values().stream().map(Binding::getExtendedInfo).collect(HashMap::new, HashMap::putAll, Map::putAll);
    }

    public void start() {
        this.bindings.values().forEach(Binding::start);
    }

    public void stop() {
        this.bindings.values().forEach(Binding::stop);
    }

    public void pause() {
        this.bindings.values().forEach(Binding::pause);
    }

    public void resume() {
        this.bindings.values().forEach(Binding::resume);
    }

    public boolean isRunning() {
        return this.bindings.values().stream().allMatch(Binding::isRunning);
    }

    public String getName() {
        return this.name;
    }

    public void unbind() {
        this.bindings.values().forEach(Binding::unbind);
    }

    public boolean isInput() {
        return this.input;
    }
}

