/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.message;

import cn.com.yusys.udp.cloud.message.MessageEvent;
import cn.com.yusys.udp.cloud.message.exception.MessageException;
import cn.com.yusys.udp.cloud.message.rule.publish.MessageQueueHelper;
import cn.com.yusys.udp.cloud.message.util.DomainHelper;
import cn.com.yusys.yusp.commons.util.StringUtils;
import javax.validation.constraints.NotEmpty;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;

public final class MqPublisher {
    private static MessageQueueHelper messageQueueHelper;

    private MqPublisher() {
    }

    public static <T> void publish(@NotEmpty String event, String bizId, T message) {
        MqPublisher.publish(event, bizId, message, true);
    }

    public static <T> void publish(MessageEvent<T> event) {
        MqPublisher.publish(MqPublisher.resolveEvent(event), event.getBizId(), event.getBody(), true, event.getDelay());
    }

    public static <T> void publishWithoutPersist(@NotEmpty String event, String bizId, T message) {
        MqPublisher.publish(event, bizId, message, false);
    }

    public static <T> void publishWithoutPersist(MessageEvent<T> event) {
        MqPublisher.publish(MqPublisher.resolveEvent(event), event.getBizId(), event.getBody(), false, event.getDelay());
    }

    public static <T> String resolveEvent(MessageEvent<T> event) {
        StringBuilder eventBuilder = new StringBuilder();
        String producer = event.getProducer();
        if (StringUtils.isEmpty((CharSequence)producer)) {
            producer = DomainHelper.currentDomain();
        }
        eventBuilder.append(producer).append(".").append(event.getConsumer()).append(".").append(event.getAction());
        return eventBuilder.toString();
    }

    private static <T> void publish(String event, String bizId, T message, boolean persist) {
        MqPublisher.publish(event, bizId, message, persist, 0L);
    }

    public static <T> void publish(@NotEmpty String event, String bizId, T message, boolean persist, long delay) {
        MqPublisher.publish(event, MqPublisher.message(bizId, persist, message, delay));
    }

    public static <T> void publish(String event, MessageBuilder<T> builder) {
        try {
            String[] split = event.split("\\.");
            if (split.length != 3) {
                throw new MessageException("Event Malformed");
            }
        }
        catch (Exception e) {
            throw new MessageException("Event Malformed");
        }
        MessageChannel messageChannel = messageQueueHelper.findOutputChannelByEvent(event);
        messageQueueHelper.fillMessageHeaders(event, builder);
        messageChannel.send(builder.build());
    }

    public static <T> MessageBuilder<T> message(String bizId, boolean persist, T payload, long delay) {
        return MessageBuilder.withPayload(payload).setHeader("bizKey", (Object)bizId).setHeader("persist", (Object)persist).setHeader("delayMill", (Object)delay);
    }

    public static void setMessageQueueHelper(MessageQueueHelper messageQueueHelper) {
        MqPublisher.messageQueueHelper = messageQueueHelper;
    }
}

