/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.util;

import cn.com.yusys.udp.cloud.commons.util.UcUtils;
import cn.com.yusys.udp.cloud.gateway.util.UcgCachedBodyOutputMessage;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class UcgUtils
extends UcUtils {
    public static final String REQUEST_ORIGIN_PATH_ATTR = UcgUtils.qualify("requestOriginPath");
    public static final String REQUEST_ORIGIN_METHOD_ATTR = UcgUtils.qualify("requestOriginMethod");
    public static final String REQUEST_START_TIME_ATTR = UcgUtils.qualify("requestStartTime");
    public static final String REQUEST_OPEN_API_ID_ATTR = UcgUtils.qualify("requestOpenApiId");
    public static final String REQUEST_OPEN_API_ADD_HEADERS_ATTR = UcgUtils.qualify("requestOpenApiAddHeaders");
    public static final String RETRY_RULE = UcgUtils.qualify("retryRule");
    public static final String DECRYPT_KEY = UcgUtils.qualify("decryptKey");
    public static final String MODULE_FLOW = "FLOW";
    public static final String MODULE_DEGRADE = "DEGRADE";
    public static final String MODULE_LOADBALANCER = "LB";
    public static final String MODULE_RETRY = "RETRY";
    public static final int FLOW_EXT_RESOURCE_MODE = 2;
    public static final String DEFAULT_CLIENT_ID_NAME = "X-Udp-Client-Id";
    public static final String DEFAULT_CLIENT_SECRET_NAME = "X-Udp-Client-Secret";
    public static final String TOKEN_KEY_NAME = "Authorization";
    public static final long DEFAULT_JWT_TIMEOUT = 3600000L;
    public static final long DEFAULT_HTTP_AUTH_TIMEOUT = 1000L;
    public static final String DEFAULT_SESSION_CONTEXT_CLASS = "cn.com.yusys.yusp.commons.session.context.UserContext";
    public static final String OPEN_API_AUTH_TYPE_SIMPLE = "simple";
    public static final String OPEN_API_AUTH_TYPE_JWT = "jwt";
    public static final String OPEN_API_AUTH_TYPE_HTTP = "http";
    public static final String OPEN_API_AUTH_TYPE_IGNORE = "ignore";
    public static final String DEFAULT_TIMESTAMP_NAME = "X-Udp-Timestamp";
    public static final String DEFAULT_NONCE_NAME = "X-Udp-Nonce";
    public static final String DEFAULT_SIGN_NAME = "X-Udp-Sign";
    public static final String DEFAULT_DECRYPT_KEY_NAME = "X-Udp-Decrypt-Key";

    public static String[] getResources(ServerWebExchange exchange, String module) {
        Route route;
        ArrayList<String> list = new ArrayList<String>();
        String openApiId = (String)exchange.getAttribute(REQUEST_OPEN_API_ID_ATTR);
        if (openApiId != null) {
            list.add(module + ":" + "API:" + openApiId);
        }
        if ((route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR)) != null && route.getId() != null) {
            list.add(module + ":" + "ROUTE:" + route.getId());
        }
        list.add(module + ":" + "SYS_GLOBAL");
        return list.toArray(new String[0]);
    }

    public static String buildRequestLog(boolean success, ServerWebExchange exchange, String msg) {
        HttpMethod httpMethod = (HttpMethod)exchange.getAttribute(REQUEST_ORIGIN_METHOD_ATTR);
        if (httpMethod == null) {
            httpMethod = exchange.getRequest().getMethod();
        }
        String method = httpMethod == null ? "" : httpMethod.name();
        RequestPath requestPath = (RequestPath)exchange.getAttribute(REQUEST_ORIGIN_PATH_ATTR);
        if (requestPath == null) {
            requestPath = exchange.getRequest().getPath();
        }
        String path = requestPath.value();
        Long startTime = (Long)exchange.getAttribute(REQUEST_START_TIME_ATTR);
        HttpStatus statusCode = exchange.getResponse().getStatusCode();
        int code = statusCode == null ? 0 : statusCode.value();
        String rt = "Request " + (success ? "proxy" : "direct") + ": " + method + " " + path + " [" + code + "]";
        if (startTime != null) {
            rt = rt + "(" + (System.currentTimeMillis() - startTime) + "ms)";
        }
        if (msg != null && !"".equals(msg.trim())) {
            rt = rt + " -> " + msg;
        }
        return rt;
    }

    public static String buildBaggageSessionContext(Map<String, Object> userInfo, String userKeyClass) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String userInfoJson = objectMapper.writeValueAsString(userInfo);
            String userKey = new String(Base64.getEncoder().encode(userInfoJson.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            HashMap<String, String> contextMap = new HashMap<String, String>(4);
            contextMap.put("UserKey", userKey);
            contextMap.put("UserKey_class", userKeyClass);
            String contextMapJson = objectMapper.writeValueAsString(contextMap);
            return new String(Base64.getEncoder().encode(contextMapJson.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    protected static String qualify(String attr) {
        return UcUtils.class.getName() + "." + attr;
    }

    public static Mono<Void> rewriteRequestBody(ServerWebExchange exchange, GatewayFilterChain chain, BiFunction<ServerWebExchange, String, Mono<String>> rewriteFunction, List<String> rmHeaders) {
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, (List)HandlerStrategies.withDefaults().messageReaders());
        Mono modifiedBody = serverRequest.bodyToMono(String.class).flatMap(originalBody -> (Mono)rewriteFunction.apply(exchange, (String)originalBody)).switchIfEmpty(Mono.defer(() -> (Mono)rewriteFunction.apply(exchange, null)));
        BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, String.class);
        HttpHeaders headers = new HttpHeaders();
        headers.putAll((Map)exchange.getRequest().getHeaders());
        headers.remove((Object)"Content-Length");
        if (rmHeaders != null) {
            for (String key : rmHeaders) {
                headers.remove((Object)key);
            }
        }
        UcgCachedBodyOutputMessage outputMessage = new UcgCachedBodyOutputMessage(exchange, headers);
        return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
            ServerHttpRequestDecorator decorator = UcgUtils.decorateRequestBody(exchange, headers, outputMessage);
            return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
        })).onErrorResume(throwable -> UcgUtils.releaseRequestBody(exchange, outputMessage, throwable));
    }

    private static Mono<Void> releaseRequestBody(ServerWebExchange exchange, UcgCachedBodyOutputMessage outputMessage, Throwable throwable) {
        if (outputMessage.isCached()) {
            return outputMessage.getBody().map(DataBufferUtils::release).then(Mono.error((Throwable)throwable));
        }
        return Mono.error((Throwable)throwable);
    }

    private static ServerHttpRequestDecorator decorateRequestBody(ServerWebExchange exchange, final HttpHeaders headers, final UcgCachedBodyOutputMessage outputMessage) {
        return new ServerHttpRequestDecorator(exchange.getRequest()){

            public HttpHeaders getHeaders() {
                long contentLength = headers.getContentLength();
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.putAll((Map)headers);
                if (contentLength > 0L) {
                    httpHeaders.setContentLength(contentLength);
                } else {
                    httpHeaders.set("Transfer-Encoding", "chunked");
                }
                return httpHeaders;
            }

            public Flux<DataBuffer> getBody() {
                return outputMessage.getBody();
            }
        };
    }

    public static Mono<Void> rewriteResponseBody(ServerWebExchange exchange, GatewayFilterChain chain, BiFunction<ServerWebExchange, String, Mono<String>> modifyBody) {
        return chain.filter(exchange.mutate().response(UcgUtils.decorateResponseBody(exchange, modifyBody)).build());
    }

    private static ServerHttpResponse decorateResponseBody(final ServerWebExchange exchange, final BiFunction<ServerWebExchange, String, Mono<String>> modifyBody) {
        return new ServerHttpResponseDecorator(exchange.getResponse()){

            public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                String originalResponseContentType = (String)exchange.getAttribute("original_response_content_type");
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.add("Content-Type", originalResponseContentType);
                ClientResponse clientResponse = ClientResponse.create((HttpStatus)Objects.requireNonNull(exchange.getResponse().getStatusCode())).headers(headers -> headers.putAll((Map)httpHeaders)).body(Flux.from(body)).build();
                Mono modifiedBody = clientResponse.bodyToMono(String.class).flatMap(originalBody -> (Mono)modifyBody.apply(exchange, originalBody)).switchIfEmpty(Mono.defer(() -> (Mono)modifyBody.apply(exchange, null)));
                BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, String.class);
                CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, exchange.getResponse().getHeaders());
                return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                    Flux messageBody = outputMessage.getBody();
                    HttpHeaders headers = this.getDelegate().getHeaders();
                    if (!headers.containsKey((Object)"Transfer-Encoding")) {
                        messageBody = messageBody.doOnNext(data -> headers.setContentLength((long)data.readableByteCount()));
                    }
                    return this.getDelegate().writeWith((Publisher)messageBody);
                }));
            }

            public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
                return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body).flatMapSequential(p -> p));
            }
        };
    }

    public static boolean antMatch(String requestPath, List<String> paths) {
        AntPathMatcher apiMatcher = new AntPathMatcher();
        for (String path : paths) {
            if (!apiMatcher.match(path, requestPath)) continue;
            return true;
        }
        return false;
    }
}

