/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import java.util.Date;
import java.util.Map;

public class UcgJwtUtils {
    public static String createToken(String secret, Long expiresAt, Map<String, String> claims) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTCreator.Builder builder = JWT.create().withExpiresAt(new Date(expiresAt));
            claims.forEach((arg_0, arg_1) -> ((JWTCreator.Builder)builder).withClaim(arg_0, arg_1));
            return builder.sign(algorithm);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public static Claim getClaim(String token, String key) {
        try {
            return JWT.decode((String)token).getClaim(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Claim> getClaims(String token) {
        try {
            return JWT.decode((String)token).getClaims();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean verifyToken(String secret, String token) {
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)secret)).build();
            verifier.verify(token);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

