/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.openapi;

import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiAuthChecker;
import cn.com.yusys.udp.cloud.gateway.util.UcgJwtUtils;
import com.auth0.jwt.interfaces.Claim;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;

public class UcgOpenApiJwtAuthChecker
implements UcgOpenApiAuthChecker {
    @Override
    public Map<String, String> check(UcgOpenApiConfig.Client client, UcgOpenApiConfig.Path path, String clientSecret, String token, ServerWebExchange exchange) {
        Claim claim;
        if (path == null) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " API not found");
        }
        if (token == null) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " token not found");
        }
        if (!client.getPathIds().contains(path.getId())) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " unauthorized request api +" + path.getId());
        }
        String[] split = token.trim().split(" ");
        if (split.length > 1) {
            token = split[split.length - 1];
        }
        if ((claim = UcgJwtUtils.getClaim(token, "client_id")) == null) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " token verify fail, token client not found");
        }
        String tokenClientId = claim.asString();
        if (tokenClientId == null || !tokenClientId.equals(client.getClientId())) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " token verify fail, client not match");
        }
        if (!UcgJwtUtils.verifyToken(client.getClientSecret(), token)) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " token verify fail");
        }
        return null;
    }

    @Override
    public boolean match(UcgOpenApiConfig.Client client) {
        return client != null && "jwt".equalsIgnoreCase(client.getAuthType());
    }
}

