/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.openapi;

import cn.com.yusys.udp.cloud.commons.util.UcCryptoUtils;
import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.context.UcgContext;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgOpenApiDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.openapi.HttpAuthPostInfo;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiAuthChecker;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultRequest;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestData;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.gateway.support.DelegatingServiceInstance;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.server.RequestPath;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.server.ServerWebExchange;

public class UcgOpenApiHttpAuthChecker
implements UcgOpenApiAuthChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String LB_SCHEME = "lb";
    protected final UcgOpenApiDepository depository;
    protected final LoadBalancerClient loadBalancer;
    protected RestTemplate restTemplate;
    protected ObjectMapper objectMapper = new ObjectMapper();

    public UcgOpenApiHttpAuthChecker(UcgOpenApiDepository depository, LoadBalancerClient loadBalancer) {
        this.depository = depository;
        this.loadBalancer = loadBalancer;
        long timeout = depository.getHttpAuthTimeout();
        this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(Duration.ofMillis(timeout)).setReadTimeout(Duration.ofMillis(timeout)).build();
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public Map<String, String> check(UcgOpenApiConfig.Client client, UcgOpenApiConfig.Path path, String clientSecret, String token, ServerWebExchange exchange) {
        if (!client.getClientSecret().equals(clientSecret)) {
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] \uff08" + client.getClientId() + "\uff09 secret not match");
        }
        URI checkUrl = this.getCheckUrl(client, exchange);
        this.logger.trace("[udp-cloud-gateway]: [OpenAPI] http check url {}", (Object)checkUrl);
        RequestPath requestPath = (RequestPath)exchange.getAttribute(UcgUtils.REQUEST_ORIGIN_PATH_ATTR);
        HttpMethod httpMethod = (HttpMethod)exchange.getAttribute(UcgUtils.REQUEST_ORIGIN_METHOD_ATTR);
        HttpAuthPostInfo postInfo = new HttpAuthPostInfo(client.getClientId(), token, requestPath == null ? null : requestPath.toString(), httpMethod);
        long start = System.currentTimeMillis();
        String resBody = this.postHttpValid(checkUrl, postInfo);
        Map<String, Object> userInfo = this.parseUserInfo(resBody);
        if (this.logger.isTraceEnabled()) {
            long cost = System.currentTimeMillis() - start;
            this.logger.trace("[udp-cloud-gateway]: [OpenAPI] http check cost {}ms, response {}", (Object)cost, (Object)userInfo.toString());
        }
        HashMap<String, String> headers = new HashMap<String, String>(4);
        String baggageSessionContext = UcgUtils.buildBaggageSessionContext(userInfo, this.depository.getSessionContextClass());
        headers.put("Baggage-Session-Context", baggageSessionContext);
        String sessionContext = UcCryptoUtils.toHexString((byte[])resBody.getBytes(StandardCharsets.UTF_8));
        headers.put("Session-Context", sessionContext);
        return headers;
    }

    protected String postHttpValid(URI url, HttpAuthPostInfo postInfo) {
        try {
            String body = this.objectMapper.writeValueAsString((Object)postInfo);
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/json;charset=UTF-8");
            HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + postInfo.getClientId() + " http valid fail, StatusCode=" + responseEntity.getStatusCode());
            }
            return (String)responseEntity.getBody();
        }
        catch (UcgException ue) {
            throw ue;
        }
        catch (Exception e) {
            this.logger.error("[udp-cloud-gateway]: [OpenAPI]", (Throwable)e);
            throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + postInfo.getClientId() + " request error");
        }
    }

    protected Map<String, Object> parseUserInfo(String responseBody) {
        try {
            return (Map)this.objectMapper.readValue(responseBody, Map.class);
        }
        catch (JsonProcessingException e) {
            this.logger.error("[udp-cloud-gateway]: [OpenAPI] response parse error: {}", (Object)responseBody);
            return new HashMap<String, Object>(4);
        }
    }

    protected URI getCheckUrl(UcgOpenApiConfig.Client client, ServerWebExchange exchange) {
        URI url = this.depository.getHttpAuthUrl();
        try {
            if (url != null && LB_SCHEME.equals(url.getScheme())) {
                if (this.loadBalancer == null) {
                    throw new UcgException(HttpStatus.INTERNAL_SERVER_ERROR, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " http check not support lb scheme," + url);
                }
                URI finalUrl = url;
                RequestData requestData = new RequestData(HttpMethod.POST, url, new HttpHeaders(), (MultiValueMap)new HttpHeaders(), new HashMap(4));
                DefaultRequest defaultRequest = new DefaultRequest((Object)new RequestDataContext(requestData));
                CompletableFuture<ServiceInstance> compInstance = CompletableFuture.supplyAsync(() -> {
                    UcgContext.setExchange(exchange);
                    ServiceInstance instance = this.loadBalancer.choose(finalUrl.getHost(), (Request)defaultRequest);
                    UcgContext.clear();
                    return instance;
                });
                ServiceInstance instance = compInstance.get();
                if (instance == null) {
                    throw new UcgException(HttpStatus.INTERNAL_SERVER_ERROR, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " http check lb instance not foud," + url.getHost());
                }
                String overrideScheme = instance.isSecure() ? "https" : "http";
                url = this.loadBalancer.reconstructURI((ServiceInstance)new DelegatingServiceInstance(instance, overrideScheme), url);
            }
            return url;
        }
        catch (Exception e) {
            this.logger.error("[udp-cloud-gateway]: [OpenAPI]", (Throwable)e);
            throw new UcgException(HttpStatus.INTERNAL_SERVER_ERROR, "[udp-cloud-gateway]: [OpenAPI] " + client.getClientId() + " http check lb instance not foud," + url.getHost());
        }
    }

    @Override
    public boolean match(UcgOpenApiConfig.Client client) {
        return client != null && "http".equalsIgnoreCase(client.getAuthType());
    }

    static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        NoOpResponseErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) throws IOException {
        }
    }
}

