/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter.ciphertext;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgBodyDecryptDepository;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyOtherProcess;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcess;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.symmetric.SM4;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;

public class UcgBodyProcessImplDefault
implements UcgBodyProcess {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private UcgBodyOtherProcess ucgBodyOtherProcess;
    static DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    public UcgBodyProcessImplDefault(UcgBodyOtherProcess ucgBodyOtherProcess) {
        this.ucgBodyOtherProcess = ucgBodyOtherProcess;
    }

    @Override
    public String requestProcess(String requestBody, UcgBodyDecryptDepository depository, ServerWebExchange exchange) {
        String mingwen = null;
        String type = exchange.getRequest().getHeaders().getFirst("request-decode-type");
        this.LOGGER.trace("request decode type {}", (Object)type);
        if (null == type) {
            throw new RuntimeException("\u4f7f\u7528\u65b9\u5f0f\u9519\u8bef\uff0c\u7f3a\u5931\u89e3\u5bc6\u65b9\u5f0f\u5934\u4fe1\u606f");
        }
        switch (type) {
            case "rsa": {
                RSA rsa = new RSA(depository.getRsaPrivateKey(), null);
                mingwen = new String(rsa.decrypt(requestBody, KeyType.PrivateKey), StandardCharsets.UTF_8);
                break;
            }
            case "sm2": {
                if (!requestBody.startsWith("04")) {
                    requestBody = "04" + requestBody;
                }
                mingwen = SmUtil.sm2((String)depository.getSm2PrivateKey(), null).decryptStr(requestBody, KeyType.PrivateKey);
                break;
            }
            case "sm2plus": {
                if (!requestBody.startsWith("04")) {
                    requestBody = "04" + requestBody;
                }
                mingwen = SmUtil.sm2((String)depository.getSm2PlusPrivateKey(), null).decryptStr(requestBody, KeyType.PrivateKey);
                mingwen = this.checkBody(mingwen);
                break;
            }
            case "sm4": {
                SM4 smTT = SmUtil.sm4((byte[])SecureUtil.decode((String)depository.getSm4PrivateKey()));
                mingwen = smTT.decryptStr(requestBody, CharsetUtil.CHARSET_UTF_8);
                break;
            }
            default: {
                mingwen = this.ucgBodyOtherProcess.requestProcess(requestBody, depository, exchange);
            }
        }
        return mingwen;
    }

    @Override
    public String responseProcess(String responseBody, UcgBodyDecryptDepository depository, ServerWebExchange exchange) {
        String miwen;
        String type = exchange.getRequest().getHeaders().getFirst("response-encode-type");
        this.LOGGER.trace("response encode type {}", (Object)type);
        if (null == type) {
            throw new RuntimeException("\u4f7f\u7528\u65b9\u5f0f\u9519\u8bef\uff0c\u7f3a\u5931\u52a0\u5bc6\u65b9\u5f0f\u5934\u4fe1\u606f");
        }
        switch (type) {
            case "rsa": {
                RSA rsa = new RSA(null, depository.getRsaPublicKey());
                miwen = HexUtil.encodeHexStr((byte[])rsa.encrypt(responseBody.getBytes(StandardCharsets.UTF_8), KeyType.PublicKey));
                break;
            }
            case "sm2": {
                miwen = SmUtil.sm2(null, (String)depository.getSm2PublicKey()).encryptHex(responseBody.getBytes(StandardCharsets.UTF_8), KeyType.PublicKey);
                break;
            }
            case "sm4": {
                SM4 smT = SmUtil.sm4((byte[])SecureUtil.decode((String)depository.getSm4PublicKey()));
                miwen = smT.encryptHex(responseBody);
                break;
            }
            default: {
                miwen = this.ucgBodyOtherProcess.responseProcess(responseBody, depository, exchange);
            }
        }
        return miwen;
    }

    private String checkBody(String body) {
        String time = body.substring(0, 19);
        time = time.replace(" ", "T");
        String bodyReal = body.substring(20);
        LocalDateTime dateTime = LocalDateTime.parse(time, formatter);
        long c = ChronoUnit.MINUTES.between(dateTime, LocalDateTime.now());
        if (c < -1L || c > 1L) {
            throw new RuntimeException("\u88ab\u4f2a\u9020\u7684\u975e\u6cd5\u62a5\u6587");
        }
        return bodyReal;
    }
}

