/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

public class UcgSwaggerFilter
implements WebFilter {
    private static final String SWAGGER_URI = "/swagger-resources";
    private final RouteDefinitionLocator locator;
    private final SwaggerResourcesProvider resourcesProvider;

    public UcgSwaggerFilter(RouteDefinitionLocator locator, SwaggerResourcesProvider resourcesProvider) {
        this.locator = locator;
        this.resourcesProvider = resourcesProvider;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String path = exchange.getRequest().getPath().toString();
        if (!SWAGGER_URI.equals(path)) {
            return chain.filter(exchange);
        }
        try {
            ArrayList resources = new ArrayList();
            List defaultResources = (List)this.resourcesProvider.get();
            List newResources = CompletableFuture.supplyAsync(() -> {
                ArrayList swaggerResources = new ArrayList();
                this.locator.getRouteDefinitions().toStream().forEach(route -> {
                    Optional<PredicateDefinition> optional = route.getPredicates().stream().filter(predicateDefinition -> "Path".equals(predicateDefinition.getName())).findFirst();
                    if (optional.isPresent()) {
                        String routeId = route.getId();
                        String host = route.getUri().getHost();
                        PredicateDefinition predicate = optional.get();
                        Map args = predicate.getArgs();
                        String pattern = (String)args.get("pattern");
                        if (pattern == null) {
                            pattern = (String)args.get("_genkey_0");
                        }
                        if (pattern != null) {
                            String location = pattern.replaceFirst("/\\*\\*", "/v2/api-docs");
                            SwaggerResource swaggerResource = new SwaggerResource();
                            swaggerResource.setName(host);
                            swaggerResource.setSwaggerVersion("2.0");
                            swaggerResource.setLocation(location);
                            swaggerResources.add(swaggerResource);
                        }
                    }
                });
                return swaggerResources;
            }).get();
            resources.addAll(defaultResources);
            resources.addAll(newResources);
            ObjectMapper objectMapper = new ObjectMapper();
            byte[] reBody = objectMapper.writeValueAsBytes(resources);
            ServerHttpResponse response = exchange.getResponse();
            return response.writeWith((Publisher)Mono.fromSupplier(() -> {
                DataBufferFactory bufferFactory = response.bufferFactory();
                return bufferFactory.wrap(reBody);
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
            return chain.filter(exchange);
        }
    }
}

