/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgRewriteResponseBodyDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.handler.UcgRewriteResponseBodyHandler;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgRewriteResponseBodyFilter
implements UcgFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ORDER = -101;
    private final UcgRewriteResponseBodyDepository depository;
    private final UcgRewriteResponseBodyHandler bodyHandler;

    public UcgRewriteResponseBodyFilter(UcgRewriteResponseBodyDepository depository, UcgRewriteResponseBodyHandler bodyHandler) {
        this.depository = depository;
        this.bodyHandler = bodyHandler;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgRewriteResponseBodyFilter start");
        String ResponsePath = exchange.getRequest().getPath().toString();
        if (!UcgUtils.antMatch(ResponsePath, this.depository.getPaths())) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[udp-cloud-gateway]: [RewriteResponseBody] ignored path: {}", (Object)ResponsePath);
            }
            return chain.filter(exchange);
        }
        if (this.bodyHandler == null) {
            this.logger.warn("[udp-cloud-gateway]: [RewriteResponseBody] ignored: handler not found");
            return chain.filter(exchange);
        }
        return UcgUtils.rewriteResponseBody(exchange, chain, (serverWebExchange, raw) -> {
            if (raw == null) {
                return Mono.empty();
            }
            try {
                return Mono.just((Object)this.bodyHandler.handle(exchange, (String)raw));
            }
            catch (Exception e) {
                this.logger.error("response body rewrite error", (Throwable)e);
                throw new UcgException(HttpStatus.FORBIDDEN, "response body rewrite error");
            }
        });
    }

    public int getOrder() {
        return -101;
    }
}

