/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.config.UcgRetryConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgRetryDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgRetryPreFilter
implements UcgFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ORDER = 10200;
    protected static final String module = "RETRY";
    protected final UcgRetryDepository depository;

    public UcgRetryPreFilter(UcgRetryDepository depository) {
        this.depository = depository;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgRetryPreFilter start");
        UcgRetryConfig.Rule rule = this.depository.getRule(UcgUtils.getResources(exchange, module));
        if (rule == null || rule.getRetryType() == UcgRetryConfig.RetryType.none || !rule.getMethods().contains(exchange.getRequest().getMethod()) || rule.getRetries() <= 0) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgRetryPreFilter cache body");
        exchange.getAttributes().put(UcgUtils.RETRY_RULE, rule);
        return this.cacheBody(exchange, chain);
    }

    public Mono<Void> cacheBody(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest cachedRequest = (ServerHttpRequest)exchange.getAttribute("cachedServerHttpRequestDecorator");
        if (cachedRequest != null) {
            exchange.getAttributes().remove("cachedServerHttpRequestDecorator");
            return chain.filter(exchange.mutate().request(cachedRequest).build());
        }
        DataBuffer body = (DataBuffer)exchange.getAttribute("cachedRequestBody");
        if (body != null) {
            return chain.filter(exchange);
        }
        return ServerWebExchangeUtils.cacheRequestBody((ServerWebExchange)exchange, serverHttpRequest -> {
            if (serverHttpRequest == exchange.getRequest()) {
                return chain.filter(exchange);
            }
            return chain.filter(exchange.mutate().request(serverHttpRequest).build());
        });
    }

    public int getOrder() {
        return 10200;
    }
}

