/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.config.UcgRetryConfig;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.DelegatingServiceInstance;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.retry.Repeat;
import reactor.retry.RepeatContext;
import reactor.retry.RetryContext;
import reactor.util.retry.Retry;

public class UcgRetryFilter
implements GlobalFilter,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(UcgRetryFilter.class);
    public static final int ORDER = 10300;
    public static final String RETRY_ITERATION_KEY = "retry_iteration";
    private final LoadBalancerClient loadBalancerClient;
    private final DiscoveryClient discoveryClient;

    public UcgRetryFilter(LoadBalancerClient loadBalancerClient, DiscoveryClient discoveryClient) {
        this.loadBalancerClient = loadBalancerClient;
        this.discoveryClient = discoveryClient;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        UcgRetryConfig.Rule rule = (UcgRetryConfig.Rule)exchange.getAttribute(UcgUtils.RETRY_RULE);
        if (rule == null) {
            return chain.filter(exchange);
        }
        logger.trace("[udp-cloud-gateway]: UcgRetryFilter start");
        return this.retryFilter(rule).filter(exchange, chain);
    }

    public GatewayFilter retryFilter(UcgRetryConfig.Rule rule) {
        int retries = rule.getRetries();
        Predicate<RepeatContext> repeatPredicate = context -> {
            boolean statusRetry;
            ServerWebExchange exchange = (ServerWebExchange)context.applicationContext();
            if (this.exceedsMaxIterations(exchange, retries)) {
                return false;
            }
            HttpStatus statusCode = exchange.getResponse().getStatusCode();
            boolean bl = statusRetry = statusCode != null && rule.getStatuses().contains(statusCode);
            if (statusRetry) {
                this.handleRetry(exchange, rule);
            }
            return statusRetry;
        };
        Repeat statusCodeRepeat = Repeat.onlyIf(repeatPredicate).doOnRepeat(context -> this.reset((ServerWebExchange)context.applicationContext()));
        Predicate<RetryContext> retryPredicate = context -> {
            boolean retry;
            ServerWebExchange exchange = (ServerWebExchange)context.applicationContext();
            if (this.exceedsMaxIterations(exchange, retries)) {
                return false;
            }
            Throwable exception = context.exception();
            boolean bl = retry = exception != null && !(exception instanceof UcgException);
            if (retry) {
                this.handleRetry(exchange, rule);
            }
            return retry;
        };
        reactor.retry.Retry exceptionRetry = reactor.retry.Retry.onlyIf(retryPredicate).doOnRetry(context -> this.reset((ServerWebExchange)context.applicationContext())).retryMax((long)retries);
        return this.apply((Repeat<ServerWebExchange>)statusCodeRepeat, (reactor.retry.Retry<ServerWebExchange>)exceptionRetry);
    }

    public void handleRetry(ServerWebExchange exchange, UcgRetryConfig.Rule rule) {
        int index;
        ServiceInstance newServer;
        Integer iteration = (Integer)exchange.getAttribute(RETRY_ITERATION_KEY);
        logger.trace("[udp-cloud-gateway]: [Retry] Iteration {} -> {}", (Object)rule.getResource(), (Object)iteration);
        if (rule.getRetryType() != UcgRetryConfig.RetryType.next) {
            return;
        }
        URI lbUrl = this.getLBUrl((LinkedHashSet)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR));
        if (lbUrl == null) {
            return;
        }
        String serviceId = lbUrl.getHost();
        List allServers = this.discoveryClient.getInstances(serviceId);
        if (allServers.size() == 0) {
            return;
        }
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        int current = 0;
        for (ServiceInstance server : allServers) {
            ++current;
            if (!requestUrl.getHost().equals(server.getHost()) || requestUrl.getPort() != server.getPort()) continue;
            break;
        }
        String overrideScheme = (newServer = (ServiceInstance)allServers.get(index = current % allServers.size())).isSecure() ? "https" : "http";
        URI newRequestUrl = this.loadBalancerClient.reconstructURI((ServiceInstance)new DelegatingServiceInstance(newServer, overrideScheme), lbUrl);
        logger.trace("[udp-cloud-gateway]: [Retry] Next {} -> {}", (Object)requestUrl, (Object)newRequestUrl);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, newRequestUrl);
    }

    public URI getLBUrl(LinkedHashSet<URI> uris) {
        if (uris == null) {
            return null;
        }
        for (URI uri : uris) {
            if (!uri.getScheme().equals("lb")) continue;
            return uri;
        }
        return null;
    }

    public boolean exceedsMaxIterations(ServerWebExchange exchange, long retries) {
        Integer iteration = (Integer)exchange.getAttribute(RETRY_ITERATION_KEY);
        return iteration != null && (long)iteration.intValue() >= retries;
    }

    public void reset(ServerWebExchange exchange) {
        Connection conn = (Connection)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        if (conn != null) {
            exchange.getAttributes().remove(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        }
        ServerWebExchangeUtils.reset((ServerWebExchange)exchange);
    }

    public GatewayFilter apply(Repeat<ServerWebExchange> repeat, reactor.retry.Retry<ServerWebExchange> retry) {
        return (exchange, chain) -> {
            Mono publisher = chain.filter(exchange).doOnSuccess(aVoid -> this.updateIteration(exchange)).doOnError(throwable -> this.updateIteration(exchange));
            if (retry != null) {
                publisher = publisher.retryWhen(Retry.withThrowable((Function)retry.withApplicationContext((Object)exchange)));
            }
            if (repeat != null) {
                publisher = publisher.repeatWhen((Function)repeat.withApplicationContext((Object)exchange));
            }
            return Mono.fromDirect((Publisher)publisher);
        };
    }

    private void updateIteration(ServerWebExchange exchange) {
        int iteration = (Integer)exchange.getAttributeOrDefault(RETRY_ITERATION_KEY, (Object)-1);
        int newIteration = iteration + 1;
        exchange.getAttributes().put(RETRY_ITERATION_KEY, newIteration);
    }

    public int getOrder() {
        return 10300;
    }
}

