/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgReleaseStrategyDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgReleaseStrategyEntity;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.util.ExpressionResolver;
import cn.hutool.core.lang.WeightRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgReleaseStrategyFilter
implements UcgFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String EXPRESSION_PREFIX = "H";
    private final UcgReleaseStrategyDepository ucgReleaseStrategyDepository;

    public UcgReleaseStrategyFilter(UcgReleaseStrategyDepository ucgReleaseStrategyDepository) {
        this.ucgReleaseStrategyDepository = ucgReleaseStrategyDepository;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.ucgReleaseStrategyDepository.isEnabled()) {
            return chain.filter(exchange);
        }
        Map<String, String> params = this.getParams(exchange);
        List<UcgReleaseStrategyEntity.BlueGreenCondition> blueGreenConditions = this.ucgReleaseStrategyDepository.getBlueGreenConditions();
        for (UcgReleaseStrategyEntity.BlueGreenCondition blueGreenCondition : blueGreenConditions) {
            String expression = blueGreenCondition.getExpression();
            if (StringUtils.isEmpty((Object)expression) || !ExpressionResolver.eval(expression, EXPRESSION_PREFIX, params)) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[udp-cloud-gateway]: UcgReleaseStrategyFilter match to blueGreenCondition, versionId: {}, regionId: {}", (Object)blueGreenCondition.getVersionId(), (Object)blueGreenCondition.getRegionId());
            }
            return chain.filter(this.addHeaders(exchange, blueGreenCondition));
        }
        UcgReleaseStrategyEntity.BlueGreenCondition basicBlueGreenCondition = this.ucgReleaseStrategyDepository.getBasicBlueGreenCondition();
        if (basicBlueGreenCondition != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[udp-cloud-gateway]: UcgReleaseStrategyFilter match to basicBlueGreenCondition, versionId: {}, regionId: {}", (Object)basicBlueGreenCondition.getVersionId(), (Object)basicBlueGreenCondition.getRegionId());
            }
            return chain.filter(this.addHeaders(exchange, basicBlueGreenCondition));
        }
        List<UcgReleaseStrategyEntity.GrayCondition> grayConditions = this.ucgReleaseStrategyDepository.getGrayConditions();
        for (UcgReleaseStrategyEntity.GrayCondition grayCondition : grayConditions) {
            String expression = grayCondition.getExpression();
            if (StringUtils.isEmpty((Object)expression) || !ExpressionResolver.eval(expression, EXPRESSION_PREFIX, params)) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[udp-cloud-gateway]: UcgReleaseStrategyFilter match to grayCondition, versionId: {}, regionId: {}", grayCondition.getVersionId(), grayCondition.getRegionId());
            }
            return chain.filter(this.addHeaders(exchange, grayCondition));
        }
        UcgReleaseStrategyEntity.GrayCondition basicGrayCondition = this.ucgReleaseStrategyDepository.getBasicGrayCondition();
        if (basicGrayCondition != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[udp-cloud-gateway]: UcgReleaseStrategyFilter match to basicGrayCondition, versionId: {}, regionId: {}", basicGrayCondition.getVersionId(), basicGrayCondition.getRegionId());
            }
            return chain.filter(this.addHeaders(exchange, basicGrayCondition));
        }
        return chain.filter(exchange);
    }

    private ServerWebExchange addHeaders(ServerWebExchange exchange, UcgReleaseStrategyEntity.BlueGreenCondition blueGreenCondition) {
        String versionId = blueGreenCondition.getVersionId();
        String regionId = blueGreenCondition.getRegionId();
        boolean faultTolerant = blueGreenCondition.isFaultTolerant();
        ServerWebExchange newExchange = !StringUtils.isEmpty((Object)versionId) ? this.buildExchange(exchange, versionId, faultTolerant, "X-Udp-Version") : this.buildExchange(exchange, regionId, faultTolerant, "X-Udp-Region");
        return newExchange != null ? newExchange : exchange;
    }

    private ServerWebExchange addHeaders(ServerWebExchange exchange, UcgReleaseStrategyEntity.GrayCondition grayCondition) {
        Map<String, Integer> versionIdMap = grayCondition.getVersionId();
        Map<String, Integer> regionIdMap = grayCondition.getRegionId();
        boolean faultTolerant = grayCondition.isFaultTolerant();
        ServerWebExchange newExchange = versionIdMap != null ? this.buildExchange(exchange, this.weightRandom(versionIdMap), faultTolerant, "X-Udp-Version") : this.buildExchange(exchange, this.weightRandom(regionIdMap), faultTolerant, "X-Udp-Region");
        return newExchange != null ? newExchange : exchange;
    }

    private ServerWebExchange buildExchange(ServerWebExchange exchange, String routeId, boolean faultTolerant, String headerName) {
        String encodedRoute;
        UcgReleaseStrategyEntity.Route route = this.ucgReleaseStrategyDepository.getRoute(routeId);
        if (route == null) {
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[udp-cloud-gateway]: UcgReleaseStrategyFilter add headers, {}: {}, {}: {}", new Object[]{headerName, route.getContent(), "X-Udp-Fault-Tolerant", faultTolerant});
        }
        if ((encodedRoute = route.getContent()) != null) {
            encodedRoute = encodedRoute.replace("{", "%7B").replace("}", "%7D");
        }
        ServerHttpRequest newRequest = exchange.getRequest().mutate().header(headerName, new String[]{encodedRoute}).header("X-Udp-Fault-Tolerant", new String[]{String.valueOf(faultTolerant)}).build();
        return exchange.mutate().request(newRequest).build();
    }

    private Map<String, String> getParams(ServerWebExchange exchange) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        HttpHeaders headers = exchange.getRequest().getHeaders();
        MultiValueMap queryParams = exchange.getRequest().getQueryParams();
        MultiValueMap cookies = exchange.getRequest().getCookies();
        cookies.toSingleValueMap().forEach((name, cookie) -> params.put((String)name, cookie.getValue()));
        params.putAll(queryParams.toSingleValueMap());
        params.putAll(headers.toSingleValueMap());
        return params;
    }

    private String weightRandom(Map<String, Integer> map) {
        WeightRandom weightRandom = new WeightRandom();
        map.forEach((arg_0, arg_1) -> ((WeightRandom)weightRandom).add(arg_0, arg_1));
        return (String)weightRandom.next();
    }

    public int getOrder() {
        return 10149;
    }
}

