/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgOpenApiDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiAuthChecker;
import cn.com.yusys.udp.cloud.gateway.openapi.UcgOpenApiAuthCheckerFactory;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import java.util.Collections;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgOpenApiFilter
implements UcgFilter {
    public static final int ORDER = -2147483448;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String HEADER_SPLIT_CHAR = ";";
    public static final String HEADER_KV_SPLIT_CHAR = "=";
    protected final UcgOpenApiDepository depository;
    protected final UcgOpenApiAuthCheckerFactory checkerFactory;

    public UcgOpenApiFilter(UcgOpenApiDepository depository, UcgOpenApiAuthCheckerFactory checkerFactory) {
        this.depository = depository;
        this.checkerFactory = checkerFactory;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        boolean changeHeader;
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgOpenApiFilter start");
        String requestPath = exchange.getRequest().getPath().toString();
        AntPathMatcher apiMatcher = new AntPathMatcher();
        for (String path : this.depository.getIgnorePaths()) {
            if (!apiMatcher.match(path, requestPath)) continue;
            this.logger.trace("[udp-cloud-gateway]: [OpenAPI] ignored path: {}", (Object)requestPath);
            return chain.filter(exchange);
        }
        RequestPath originPath = (RequestPath)exchange.getAttribute(UcgUtils.REQUEST_ORIGIN_PATH_ATTR);
        HttpMethod originMethod = (HttpMethod)exchange.getAttribute(UcgUtils.REQUEST_ORIGIN_METHOD_ATTR);
        if (originPath == null || originMethod == null) {
            throw new UcgException(HttpStatus.INTERNAL_SERVER_ERROR, "RequestPath=" + originPath + ",HttpMethod:" + originMethod);
        }
        String path = originPath.toString();
        String method = originMethod.name();
        ServerHttpRequest request = exchange.getRequest();
        UcgOpenApiConfig.Path openApiPath = this.depository.getPath(method, path);
        String clientId = request.getHeaders().getFirst(this.depository.getClientIdName());
        if (clientId == null || "".equals(clientId.trim())) {
            clientId = this.depository.getDefaultClientId();
        }
        UcgOpenApiConfig.Client client = this.depository.getClients().get(clientId);
        String clientSecret = request.getHeaders().getFirst(this.depository.getClientSecretName());
        if (clientSecret == null || "".equals(clientSecret.trim())) {
            clientSecret = this.depository.getDefaultClientSecret();
        }
        String token = request.getHeaders().getFirst(this.depository.getTokenName());
        HashMap newHeaders = null;
        if (openApiPath == null || !openApiPath.isOpen()) {
            UcgOpenApiAuthChecker authChecker = this.checkerFactory.match(client);
            if (authChecker == null) {
                throw new UcgException(HttpStatus.UNAUTHORIZED, "[udp-cloud-gateway]: [OpenAPI] " + clientId + " auth type " + (client == null ? null : client.getAuthType()) + " not support");
            }
            newHeaders = authChecker.check(client, openApiPath, clientSecret, token, exchange);
        }
        if (openApiPath != null) {
            exchange.getAttributes().put(UcgUtils.REQUEST_OPEN_API_ID_ATTR, openApiPath.getId());
            String defaultHeaders = openApiPath.getDefaultHeaders();
            HashMap<String, String> defaultHeaderMap = new HashMap<String, String>(16);
            if (!StringUtils.isEmpty((Object)defaultHeaders)) {
                for (String item : defaultHeaders.split(HEADER_SPLIT_CHAR)) {
                    String[] kv = item.split(HEADER_KV_SPLIT_CHAR);
                    defaultHeaderMap.put(kv[0], kv[1]);
                }
                if (newHeaders == null) {
                    newHeaders = defaultHeaderMap;
                } else {
                    newHeaders.putAll(defaultHeaderMap);
                }
            }
            this.logger.trace("[udp-cloud-gateway]: [OpenAPI] API id: {}", (Object)openApiPath.getId());
        }
        boolean bl = changeHeader = !this.depository.isKeepClientSecret() || newHeaders != null && newHeaders.size() > 0;
        if (changeHeader) {
            String passwordKeyName = this.depository.getClientSecretName();
            HashMap finalNewHeaders = newHeaders == null ? new HashMap(0) : newHeaders;
            ServerHttpRequest newRequest = exchange.getRequest().mutate().headers(httpHeaders -> {
                if (!this.depository.isKeepClientSecret()) {
                    httpHeaders.remove((Object)passwordKeyName);
                }
                for (String key : finalNewHeaders.keySet()) {
                    httpHeaders.put(key, Collections.singletonList(finalNewHeaders.get(key)));
                }
            }).build();
            return chain.filter(exchange.mutate().request(newRequest).build());
        }
        return chain.filter(exchange);
    }

    public int getOrder() {
        return -2147483448;
    }
}

