/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.filter;

import cn.com.yusys.udp.cloud.gateway.depositories.UcgBodyDecryptDepository;
import cn.com.yusys.udp.cloud.gateway.exception.UcgException;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcess;
import cn.com.yusys.udp.cloud.gateway.filter.ciphertext.UcgBodyProcessSwitch;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgBodyDecryptFilter
implements UcgFilter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ORDER = -2147473648;
    private final UcgBodyDecryptDepository depository;
    private UcgBodyProcess ucgBodyProcess;
    private UcgBodyProcessSwitch ucgBodyProcessSwitch;

    public UcgBodyDecryptFilter(UcgBodyDecryptDepository depository, UcgBodyProcess ucgBodyProcess, UcgBodyProcessSwitch ucgBodyProcessSwitch) {
        this.depository = depository;
        this.ucgBodyProcess = ucgBodyProcess;
        this.ucgBodyProcessSwitch = ucgBodyProcessSwitch;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        if (!this.depository.isEnabled()) {
            return chain.filter(exchange);
        }
        this.logger.trace("[udp-cloud-gateway]: UcgBodyDecryptFilter start");
        String requestPath = exchange.getRequest().getPath().toString();
        if (!this.ucgBodyProcessSwitch.requestProcessSwitch(exchange, this.depository)) {
            this.logger.trace("[udp-cloud-gateway]: [BodyDecrypt] skip, path: {}", (Object)requestPath);
            return chain.filter(exchange);
        }
        return UcgUtils.rewriteRequestBody(exchange, chain, (serverWebExchange, raw) -> {
            if (raw == null) {
                return Mono.empty();
            }
            try {
                return Mono.just((Object)this.ucgBodyProcess.requestProcess((String)raw, this.depository, exchange));
            }
            catch (Exception e) {
                this.logger.error("body decode error", (Throwable)e);
                throw new UcgException(HttpStatus.FORBIDDEN, "body decode error");
            }
        }, null);
    }

    public int getOrder() {
        return -2147473648;
    }
}

