/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.depositories;

import cn.com.yusys.udp.cloud.gateway.config.UcgReleaseStrategyConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgReleaseStrategyEntity;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import org.springframework.util.StringUtils;

public class UcgReleaseStrategyDepository
extends UcgDepository<UcgReleaseStrategyConfig> {
    private static final String BASIC_CONDITION = "basicCondition";
    private static UcgReleaseStrategyDepository instance;
    private UcgReleaseStrategyEntity ucgReleaseStrategyEntity;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public UcgReleaseStrategyDepository(UcgReleaseStrategyConfig ucgConfig) {
        super(ucgConfig);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        instance = this;
    }

    @Override
    public synchronized void reload() {
        String content = ((UcgReleaseStrategyConfig)this.ucgConfig).getContent();
        if (!StringUtils.isEmpty((Object)content)) {
            this.ucgReleaseStrategyEntity = this.jsonParse(content, UcgReleaseStrategyEntity.class);
        }
    }

    @Override
    public <U> U jsonParse(String json, Class<U> clazz) {
        try {
            return (U)this.objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static UcgReleaseStrategyDepository getInstance() {
        return instance;
    }

    public List<UcgReleaseStrategyEntity.BlueGreenCondition> getBlueGreenConditions() {
        return this.ucgReleaseStrategyEntity != null && this.ucgReleaseStrategyEntity.getBlueGreenConditions() != null ? this.ucgReleaseStrategyEntity.getBlueGreenConditions() : Collections.emptyList();
    }

    public UcgReleaseStrategyEntity.BlueGreenCondition getBasicBlueGreenCondition() {
        return this.getBlueGreenConditions().stream().filter(condition -> BASIC_CONDITION.equals(condition.getId())).findFirst().orElse(null);
    }

    public List<UcgReleaseStrategyEntity.GrayCondition> getGrayConditions() {
        return this.ucgReleaseStrategyEntity != null && this.ucgReleaseStrategyEntity.getGrayConditions() != null ? this.ucgReleaseStrategyEntity.getGrayConditions() : Collections.emptyList();
    }

    public UcgReleaseStrategyEntity.GrayCondition getBasicGrayCondition() {
        return this.getGrayConditions().stream().filter(condition -> BASIC_CONDITION.equals(condition.getId())).findFirst().orElse(null);
    }

    public UcgReleaseStrategyEntity.Route getRoute(String id) {
        if (StringUtils.isEmpty((Object)id) || this.ucgReleaseStrategyEntity == null || this.ucgReleaseStrategyEntity.getRoutes() == null) {
            return null;
        }
        for (UcgReleaseStrategyEntity.Route route : this.ucgReleaseStrategyEntity.getRoutes()) {
            if (!id.equals(route.getId())) continue;
            return route;
        }
        return null;
    }
}

