/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.depositories;

import cn.com.yusys.udp.cloud.gateway.config.UcgOpenApiConfig;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDepository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.util.AntPathMatcher;

public class UcgOpenApiDepository
extends UcgDepository<UcgOpenApiConfig> {
    protected Map<String, UcgOpenApiConfig.Path> paths = new HashMap<String, UcgOpenApiConfig.Path>(16);
    protected Map<String, UcgOpenApiConfig.Client> clients = new HashMap<String, UcgOpenApiConfig.Client>(16);
    private List<UcgOpenApiConfig.Path> antPaths = new ArrayList<UcgOpenApiConfig.Path>();

    public UcgOpenApiDepository(UcgOpenApiConfig config) {
        super(config);
    }

    @Override
    public synchronized void reload() {
        this.parseOpenApis();
    }

    private void parseOpenApis() {
        HashMap<String, UcgOpenApiConfig.Path> paths = new HashMap<String, UcgOpenApiConfig.Path>(16);
        ArrayList<UcgOpenApiConfig.Path> antPaths = new ArrayList<UcgOpenApiConfig.Path>();
        for (UcgOpenApiConfig.Path path : this.parsePaths()) {
            String uri = path.getUri();
            String url = "/" + path.getPrefix() + uri;
            paths.put(path.getMethod().name() + ":" + url, path);
            String antUri = uri.replaceAll("\\{\\w+\\}", "*");
            if (antUri.equals(uri)) continue;
            UcgOpenApiConfig.Path antPath = new UcgOpenApiConfig.Path();
            BeanUtils.copyProperties((Object)path, (Object)antPath);
            antPath.setUri(antUri);
            antPaths.add(antPath);
        }
        this.paths = paths;
        this.antPaths = antPaths;
        HashMap<String, UcgOpenApiConfig.Client> clients = new HashMap<String, UcgOpenApiConfig.Client>(16);
        for (UcgOpenApiConfig.Client client : this.parseClients()) {
            clients.put(client.getClientId(), client);
        }
        this.clients = clients;
    }

    private List<UcgOpenApiConfig.Client> parseClients() {
        ArrayList<UcgOpenApiConfig.Client> clients = new ArrayList<UcgOpenApiConfig.Client>();
        if (((UcgOpenApiConfig)this.ucgConfig).getClientsString() != null && !"".equals(((UcgOpenApiConfig)this.ucgConfig).getClientsString().trim())) {
            UcgOpenApiConfig.Client[] sClients = this.jsonParse(((UcgOpenApiConfig)this.ucgConfig).getClientsString(), UcgOpenApiConfig.Client[].class);
            if (sClients == null) {
                this.logger.error("[udp-cloud-gateway]: UcgOpenApiConfig.ClientString parse error: {}", (Object)((UcgOpenApiConfig)this.ucgConfig).getClientsString());
            } else {
                clients.addAll(Arrays.asList(sClients));
            }
        }
        for (String clientStr : ((UcgOpenApiConfig)this.ucgConfig).getClients()) {
            UcgOpenApiConfig.Client client = this.jsonParse(clientStr, UcgOpenApiConfig.Client.class);
            if (client == null) {
                this.logger.error("[udp-cloud-gateway]: UcgOpenApiConfig.Client parse error: {}", (Object)clientStr);
                continue;
            }
            clients.add(client);
        }
        return clients;
    }

    private List<UcgOpenApiConfig.Path> parsePaths() {
        ArrayList<UcgOpenApiConfig.Path> paths = new ArrayList<UcgOpenApiConfig.Path>();
        if (((UcgOpenApiConfig)this.ucgConfig).getPathsString() != null && !"".equals(((UcgOpenApiConfig)this.ucgConfig).getPathsString().trim())) {
            UcgOpenApiConfig.Path[] sPaths = this.jsonParse(((UcgOpenApiConfig)this.ucgConfig).getPathsString(), UcgOpenApiConfig.Path[].class);
            if (sPaths == null) {
                this.logger.error("[udp-cloud-gateway]: UcgOpenApiConfig.PathString parse error: {}", (Object)((UcgOpenApiConfig)this.ucgConfig).getPathsString());
            } else {
                paths.addAll(Arrays.asList(sPaths));
            }
        }
        for (String pathStr : ((UcgOpenApiConfig)this.ucgConfig).getPaths()) {
            UcgOpenApiConfig.Path path = this.jsonParse(pathStr, UcgOpenApiConfig.Path.class);
            if (path == null) {
                this.logger.error("[udp-cloud-gateway]: UcgOpenApiConfig.Path parse error: {}", (Object)pathStr);
                continue;
            }
            paths.add(path);
        }
        return paths;
    }

    public UcgOpenApiConfig.Path getPath(String method, String path) {
        String key = method + ":" + path;
        UcgOpenApiConfig.Path api = this.paths.get(key);
        if (api != null) {
            return api;
        }
        AntPathMatcher pathMatcher = new AntPathMatcher();
        for (UcgOpenApiConfig.Path antPath : this.antPaths) {
            if (!method.equals(antPath.getMethod().name()) || !pathMatcher.match("/" + antPath.getPrefix() + antPath.getUri(), path)) continue;
            return antPath;
        }
        return null;
    }

    public Map<String, UcgOpenApiConfig.Path> getPaths() {
        return Collections.unmodifiableMap(this.paths);
    }

    public List<UcgOpenApiConfig.Path> getAntPaths() {
        return Collections.unmodifiableList(this.antPaths);
    }

    public Map<String, UcgOpenApiConfig.Client> getClients() {
        return Collections.unmodifiableMap(this.clients);
    }

    public String getClientIdName() {
        return ((UcgOpenApiConfig)this.ucgConfig).getClientIdName();
    }

    public String getClientSecretName() {
        return ((UcgOpenApiConfig)this.ucgConfig).getClientSecretName();
    }

    public String getTokenName() {
        return ((UcgOpenApiConfig)this.ucgConfig).getTokenName();
    }

    public boolean isKeepClientSecret() {
        return ((UcgOpenApiConfig)this.ucgConfig).isKeepClientSecret();
    }

    public long getJwtTimeout() {
        return ((UcgOpenApiConfig)this.ucgConfig).getJwtTimeout();
    }

    public long getHttpAuthTimeout() {
        return ((UcgOpenApiConfig)this.ucgConfig).getHttpAuthTimeout();
    }

    public URI getHttpAuthUrl() {
        return ((UcgOpenApiConfig)this.ucgConfig).getHttpAuthUrl();
    }

    public List<String> getIgnorePaths() {
        return ((UcgOpenApiConfig)this.ucgConfig).getIgnorePaths();
    }

    public String getSessionContextClass() {
        return ((UcgOpenApiConfig)this.ucgConfig).getSessionContextClass();
    }

    public String getDefaultClientId() {
        return ((UcgOpenApiConfig)this.ucgConfig).getDefaultClientId();
    }

    public String getDefaultClientSecret() {
        return ((UcgOpenApiConfig)this.ucgConfig).getDefaultClientSecret();
    }
}

