/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway.depositories;

import cn.com.yusys.udp.cloud.commons.util.UcCryptoUtils;
import cn.com.yusys.udp.cloud.gateway.config.UcgConfig;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UcgDepository<T extends UcgConfig> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String md5 = "";
    protected T ucgConfig;

    protected UcgDepository(T ucgConfig) {
        this.ucgConfig = ucgConfig;
    }

    @PostConstruct
    public void init() {
        this.onRefresh();
    }

    public void onRefresh() {
        String newMd5 = UcCryptoUtils.toHexString((byte[])UcCryptoUtils.md5((String)((UcgConfig)this.ucgConfig).toJson()));
        if (this.md5.equals(newMd5)) {
            return;
        }
        this.md5 = newMd5;
        this.reload();
        this.logger.trace("[udp-cloud-gateway]: refreshed depository -> {}", (Object)this.getName());
    }

    public <U> U jsonParse(String json, Class<U> clazz) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (U)objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public boolean isEnabled() {
        return ((UcgConfig)this.ucgConfig).isEnabled();
    }

    public abstract void reload();

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

