/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.udp.cloud.gateway;

import cn.com.yusys.udp.cloud.gateway.config.UcgResponse;
import cn.com.yusys.udp.cloud.gateway.context.UcgContext;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgDegradeInDepository;
import cn.com.yusys.udp.cloud.gateway.depositories.UcgFlowInDepository;
import cn.com.yusys.udp.cloud.gateway.filter.UcgFilter;
import cn.com.yusys.udp.cloud.gateway.util.UcgUtils;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import java.net.ConnectException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class UcgErrorWebExceptionHandler
implements ErrorWebExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<UcgFilter> ucgFilters;
    @Autowired(required=false)
    private UcgFlowInDepository flowInDepository;
    @Autowired(required=false)
    private UcgDegradeInDepository degradeInDepository;
    private final List<HttpMessageReader<?>> messageReaders;
    private final List<HttpMessageWriter<?>> messageWriters;
    private final List<ViewResolver> viewResolvers;
    private final ThreadLocal<UcgResponse> exceptionHandlerResult = new ThreadLocal();

    public UcgErrorWebExceptionHandler(List<UcgFilter> ucgFilters, List<HttpMessageReader<?>> messageReaders, List<HttpMessageWriter<?>> messageWriters, List<ViewResolver> viewResolvers) {
        this.ucgFilters = ucgFilters;
        this.messageReaders = messageReaders;
        this.messageWriters = messageWriters;
        this.viewResolvers = viewResolvers;
    }

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        HttpStatus status;
        this.exceptionHandlerResult.remove();
        ServerHttpResponse exchangeResponse = exchange.getResponse();
        if (exchangeResponse.isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        String resBody = null;
        String contentType = "text/html;charset=utf-8";
        if (ex instanceof ResponseStatusException) {
            ResponseStatusException rex = (ResponseStatusException)ex;
            status = rex.getStatus();
            if (((ResponseStatusException)ex).getStatus().value() >= 500) {
                this.logger.error(UcgUtils.buildRequestLog(false, exchange, rex.getReason()), ex);
            } else {
                this.logger.warn(UcgUtils.buildRequestLog(false, exchange, rex.getReason()), ex);
            }
        } else if (ex instanceof ConnectException) {
            status = HttpStatus.BAD_GATEWAY;
            this.logger.error(UcgUtils.buildRequestLog(false, exchange, ex.toString()), ex);
        } else if (ex instanceof BlockException) {
            status = HttpStatus.FORBIDDEN;
            BlockException bex = (BlockException)ex;
            UcgResponse res = this.handleBlockException(bex);
            if (res != null) {
                resBody = res.getBody();
                status = res.getStatus();
                contentType = res.getContentType();
            }
            this.logger.error(UcgUtils.buildRequestLog(false, exchange, bex.getRule().getResource() + "=" + ex.getClass().getSimpleName()), ex);
        } else {
            status = HttpStatus.INTERNAL_SERVER_ERROR;
            this.logger.error(UcgUtils.buildRequestLog(false, exchange, ex.toString()));
            this.logger.error("", ex);
        }
        UcgContext.clear();
        if (this.ucgFilters != null) {
            for (UcgFilter ucgFilter : this.ucgFilters) {
                try {
                    ucgFilter.errorFilter(exchange);
                }
                catch (Exception e) {
                    this.logger.error("errorFilter", (Throwable)e);
                }
            }
        }
        if (resBody == null) {
            resBody = status.value() + " " + status.getReasonPhrase();
        }
        this.exceptionHandlerResult.set(new UcgResponse(status, contentType, resBody));
        ServerRequest newRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), this::renderErrorResponse).route(newRequest).switchIfEmpty(Mono.error((Throwable)ex)).flatMap(handler -> handler.handle(newRequest)).flatMap(response -> this.write(exchange, (ServerResponse)response));
    }

    private Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        UcgResponse responseBean = this.exceptionHandlerResult.get();
        return ServerResponse.status((HttpStatus)responseBean.getStatus()).contentType(MediaType.parseMediaType((String)responseBean.getContentType())).body(BodyInserters.fromValue((Object)responseBean.getBody()));
    }

    protected UcgResponse handleBlockException(BlockException bex) {
        String resource = bex.getRule().getResource();
        UcgResponse res = null;
        if (bex instanceof ParamFlowException) {
            if (this.flowInDepository != null) {
                res = this.flowInDepository.getResponse(resource);
            }
        } else if (bex instanceof DegradeException && this.degradeInDepository != null) {
            res = this.degradeInDepository.getResponse(resource);
        }
        return res;
    }

    private Mono<? extends Void> write(ServerWebExchange exchange, ServerResponse response) {
        exchange.getResponse().getHeaders().setContentType(response.headers().getContentType());
        return response.writeTo(exchange, (ServerResponse.Context)new ResponseContext());
    }

    private class ResponseContext
    implements ServerResponse.Context {
        private ResponseContext() {
        }

        public List<HttpMessageWriter<?>> messageWriters() {
            return UcgErrorWebExceptionHandler.this.messageWriters;
        }

        public List<ViewResolver> viewResolvers() {
            return UcgErrorWebExceptionHandler.this.viewResolvers;
        }
    }
}

