/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.shuffle.spring.dashboard.rest;

import cn.com.yusys.shuffle.spring.dashboard.DecisionFlowStatus;
import cn.com.yusys.shuffle.spring.dashboard.FunctionStatus;
import cn.com.yusys.shuffle.spring.dashboard.RuleSetStatus;
import cn.com.yusys.shuffle.spring.dashboard.RuleStatus;
import cn.com.yusys.shuffle.spring.dashboard.StrategyStatus;
import com.ecc.shuffle.rule.Rule;
import com.ecc.shuffle.rule.RuleBase;
import com.ecc.shuffle.rule.RuleSet;
import com.ecc.shuffle.rule.chamption.ChamptionManager;
import com.ecc.shuffle.rule.chamption.util.ChamptionStrategy;
import com.ecc.shuffle.upgrade.decisionflow.DecisionFlowManager;
import com.ecc.shuffle.upgrade.decisionflow.basic.DecisionFlowNode;
import com.ecc.shuffle.upgrade.function.FunctionManager;
import com.ecc.shuffle.upgrade.function.unit.FunctionInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jci.ReloadingClassLoader;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/shuffle/dashboard"})
public class ShuffleDashboardController {
    @GetMapping(value={"/ruleSets"})
    public List<RuleSetStatus> listRuleSet() {
        RuleBase ruleBase = RuleBase.getInstance();
        ArrayList<RuleSetStatus> result = new ArrayList<RuleSetStatus>();
        ruleBase.doWidthRuleSet(ruleSet -> {
            RuleSetStatus rs = new RuleSetStatus();
            rs.setId(ruleSet.ids);
            rs.setName(ruleSet.name);
            rs.setVersion(ruleSet.version);
            String className = ruleSet.classname;
            try {
                rs.setClassName(className);
                Class clazz = ruleBase.getClassLoader().loadClass(className);
                rs.setClassLoaded(true);
                Method method = clazz.getMethod("getVersion", new Class[0]);
                if (method != null) {
                    String version = (String)method.invoke(null, new Object[0]);
                    rs.setClassVersion(version);
                }
            }
            catch (ClassNotFoundException e) {
                rs.setClassLoaded(false);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
            result.add(rs);
        });
        return result;
    }

    @GetMapping(value={"/rules/{ruleSetId}"})
    public List<RuleStatus> listRules(@PathVariable String ruleSetId) {
        RuleSet ruleSet = RuleBase.getInstance().getRuleSet(ruleSetId);
        if (ruleSet != null) {
            RuleStatus status = null;
            Rule[] rules = ruleSet.getRules();
            ArrayList<RuleStatus> result = new ArrayList<RuleStatus>(rules.length);
            for (Rule rule : rules) {
                status = new RuleStatus();
                status.setId(rule.id);
                status.setName(rule.name);
                status.setStatus(rule.runStatus);
                status.setRuleType(rule.ruletype);
                status.setContent(rule.consequence);
                result.add(status);
            }
            return result;
        }
        return new ArrayList<RuleStatus>(0);
    }

    @PostMapping(value={"/rule/{ruleSetId}/{ruleId}/{status}"})
    public void changeRuleStatus(@PathVariable String ruleSetId, @PathVariable String ruleId, @PathVariable int status) {
        Rule rule;
        RuleSet ruleSet = RuleBase.getInstance().getRuleSet(ruleSetId);
        if (ruleSetId != null && (rule = ruleSet.getRule(ruleId)) != null) {
            rule.runStatus = status;
        }
    }

    @GetMapping(value={"/functions"})
    public List<FunctionStatus> listFunctions() {
        Map functions = FunctionManager.getInstance().getAllFunctions();
        ArrayList<FunctionStatus> result = new ArrayList<FunctionStatus>(functions.size());
        Iterator it = functions.values().iterator();
        FunctionInfo functionInfo = null;
        FunctionStatus status = null;
        ReloadingClassLoader classLoader = RuleBase.getInstance().getClassLoader();
        while (it.hasNext()) {
            functionInfo = (FunctionInfo)it.next();
            status = new FunctionStatus();
            status.setName(functionInfo.getFunctionName());
            status.setClassName(functionInfo.getClassName());
            try {
                classLoader.loadClass(functionInfo.getClassName());
                status.setClassLoaded(true);
            }
            catch (ClassNotFoundException e) {
                status.setClassLoaded(false);
            }
            result.add(status);
        }
        return result;
    }

    @GetMapping(value={"/strategys"})
    public List<StrategyStatus> listStrategys() {
        Map strategys = ChamptionManager.getInstance().getStrategyList();
        ArrayList<StrategyStatus> result = new ArrayList<StrategyStatus>(strategys.size());
        Iterator it = strategys.values().iterator();
        ChamptionStrategy functionInfo = null;
        StrategyStatus status = null;
        ReloadingClassLoader classLoader = RuleBase.getInstance().getClassLoader();
        while (it.hasNext()) {
            functionInfo = (ChamptionStrategy)it.next();
            status = new StrategyStatus();
            status.setName(functionInfo.getName());
            status.setClassName(functionInfo.getClassName());
            try {
                classLoader.loadClass(functionInfo.getClassName());
                status.setClassLoaded(true);
            }
            catch (ClassNotFoundException e) {
                status.setClassLoaded(false);
            }
            result.add(status);
        }
        return result;
    }

    @GetMapping(value={"/flows"})
    public List<DecisionFlowStatus> listFlows() {
        List flowNodes = DecisionFlowManager.getInstance().getDecisionFlowList();
        ArrayList<DecisionFlowStatus> result = new ArrayList<DecisionFlowStatus>(flowNodes.size());
        DecisionFlowStatus status = null;
        for (DecisionFlowNode node : flowNodes) {
            status = new DecisionFlowStatus();
            status.setId(node.getId());
            status.setName(node.getName());
            status.setDesc(node.getDesc());
            result.add(status);
        }
        return result;
    }
}

