/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.icsp.commons.mapper.interceptor;

import cn.com.yusys.icsp.commons.mapper.log.SqlLogger;
import cn.com.yusys.icsp.commons.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class})})
public class SqlLoggerInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        long startTime = System.currentTimeMillis();
        try {
            Object[] objects = invocation.getArgs();
            Object object = invocation.proceed();
            this.outSqlExecuteInfo(System.currentTimeMillis() - startTime, invocation, true);
            return object;
        }
        catch (Exception var6) {
            this.outSqlExecuteInfo(System.currentTimeMillis() - startTime, invocation, false);
            throw var6;
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private void outSqlExecuteInfo(long timeMillseconds, Invocation invocation, boolean isSuccess) {
        Object obj;
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObjectHandler = SystemMetaObject.forObject((Object)statementHandler);
        while (metaObjectHandler.hasGetter("h")) {
            obj = metaObjectHandler.getValue("h");
            if (!(metaObjectHandler = SystemMetaObject.forObject((Object)obj)).hasGetter("target")) continue;
            obj = metaObjectHandler.getValue("target");
            metaObjectHandler = SystemMetaObject.forObject((Object)obj);
        }
        while (metaObjectHandler.hasGetter("target")) {
            obj = metaObjectHandler.getValue("target");
            if (!(metaObjectHandler = SystemMetaObject.forObject((Object)obj)).hasGetter("h")) continue;
            obj = metaObjectHandler.getValue("h");
            metaObjectHandler = SystemMetaObject.forObject((Object)obj);
        }
        MappedStatement mappedStatement = (MappedStatement)metaObjectHandler.getValue("delegate.mappedStatement");
        String sqlId = mappedStatement.getId();
        ParameterHandler parameterHandler = (ParameterHandler)metaObjectHandler.getValue("delegate.parameterHandler");
        String executeSql = this.beautifySql((String)metaObjectHandler.getValue("delegate.boundSql.sql"));
        CustomizedParameterHandler customizedParameterHandler = new CustomizedParameterHandler(mappedStatement, parameterHandler.getParameterObject(), (BoundSql)metaObjectHandler.getValue("delegate.boundSql"));
        customizedParameterHandler.setParameters(null);
        if (isSuccess) {
            SqlLogger.info(timeMillseconds, sqlId, executeSql, isSuccess, customizedParameterHandler.getParameters());
        } else {
            SqlLogger.error(timeMillseconds, sqlId, executeSql, isSuccess, customizedParameterHandler.getParameters());
        }
    }

    private String beautifySql(String sql) {
        return StringUtil.isNotEmpty((CharSequence)sql) ? sql.replaceAll("[\\s\n ]+", " ") : "";
    }

    private class CustomizedParameterHandler
    implements ParameterHandler {
        private final TypeHandlerRegistry typeHandlerRegistry;
        private final Object parameterObject;
        private final BoundSql boundSql;
        private final Configuration configuration;
        private Object[] params;

        public CustomizedParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
            this.configuration = mappedStatement.getConfiguration();
            this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
            this.parameterObject = parameterObject;
            this.boundSql = boundSql;
        }

        public Object getParameterObject() {
            return this.parameterObject;
        }

        public Object[] getParameters() {
            return this.params;
        }

        public void setParameters(PreparedStatement ps) {
            LinkedList<Object> listParams = new LinkedList<Object>();
            List parameterMappings = this.boundSql.getParameterMappings();
            if (parameterMappings != null) {
                for (int i = 0; i < parameterMappings.size(); ++i) {
                    Object value;
                    ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                    if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                    String propertyName = parameterMapping.getProperty();
                    if (this.boundSql.hasAdditionalParameter(propertyName)) {
                        value = this.boundSql.getAdditionalParameter(propertyName);
                    } else if (this.parameterObject == null) {
                        value = null;
                    } else if (this.typeHandlerRegistry.hasTypeHandler(this.parameterObject.getClass())) {
                        value = this.parameterObject;
                    } else {
                        MetaObject metaObject = this.configuration.newMetaObject(this.parameterObject);
                        value = metaObject.getValue(propertyName);
                    }
                    listParams.add(value);
                }
            }
            this.params = listParams.toArray();
        }
    }
}

