/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.es.event;

import cn.com.yusys.es.event.DomainEventEntry;
import cn.com.yusys.es.stream.StreamEventHandler;
import cn.com.yusys.es.stream.StreamHandlerException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class StreamDomainEventDispatcher
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(StreamDomainEventDispatcher.class);
    private final ObjectMapper mapper;
    private HashMap<Object, List<Method>> beanHandlerMap = new HashMap();

    @Transactional
    public void dispatchEvent(DomainEventEntry event) {
        log.info(MessageFormat.format("message [{0}] received", event.getId()));
        this.beanHandlerMap.forEach((key, value) -> {
            Optional<Method> matchedMethod = this.getMatchedMethods((List<Method>)value, event.getEventType());
            matchedMethod.ifPresent(method -> {
                try {
                    this.invoke(key, (Method)method, event);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new StreamHandlerException(MessageFormat.format("[{0}] invoke error", method.getName()), e);
                }
            });
            if (!matchedMethod.isPresent()) {
                log.info(MessageFormat.format("message [{0}] has no listener", event.getId()));
            }
        });
        log.info(MessageFormat.format("message [{0}] handled", event.getId()));
    }

    @Transactional
    public Optional<Method> getMatchedMethods(List<Method> methods, String eventType) {
        List results = methods.stream().filter(m -> {
            StreamEventHandler handler = m.getAnnotation(StreamEventHandler.class);
            ArrayList<String> types = new ArrayList<String>(Arrays.asList(handler.types()));
            types.removeIf(StringUtils::isBlank);
            return types.contains(eventType);
        }).collect(Collectors.toList());
        if (results.size() > 1) {
            throw new StreamHandlerException(MessageFormat.format("type[{0}] has more than one handler", eventType));
        }
        return results.size() == 1 ? Optional.of(results.get(0)) : Optional.empty();
    }

    @Transactional
    public void invoke(Object bean, Method method, DomainEventEntry event) throws IllegalAccessException, InvocationTargetException {
        Class<?> payloadType;
        int count = method.getParameterCount();
        if (count == 0) {
            method.invoke(bean, new Object[0]);
        } else if (count == 1 && (payloadType = method.getParameterTypes()[0]).equals(DomainEventEntry.class)) {
            method.invoke(bean, event);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> targetClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
        Method[] uniqueDeclaredMethods = ReflectionUtils.getUniqueDeclaredMethods(targetClass);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : uniqueDeclaredMethods) {
            StreamEventHandler streamListener = (StreamEventHandler)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, StreamEventHandler.class);
            if (streamListener == null) continue;
            log.info("Find StreamEventHandler methods {}", (Object)method.getName());
            methods.add(method);
        }
        if (!CollectionUtils.isEmpty(methods)) {
            this.beanHandlerMap.put(bean, methods);
        }
        return bean;
    }

    public StreamDomainEventDispatcher(ObjectMapper mapper, HashMap<Object, List<Method>> beanHandlerMap) {
        this.mapper = mapper;
        this.beanHandlerMap = beanHandlerMap;
    }
}

