/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.es.event;

import cn.com.yusys.es.event.DomainEventEntry;
import cn.com.yusys.es.event.DomainEventEntryRepository;
import cn.com.yusys.es.publisher.DomainEventEntryDynamicPublisher;
import java.util.concurrent.CompletableFuture;
import javax.persistence.PostPersist;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class DomainEventEntryListener {
    private static final Logger log = LoggerFactory.getLogger(DomainEventEntryListener.class);
    static DomainEventEntryRepository domainEventEntryRepository;
    static DomainEventEntryDynamicPublisher domainEventEntryDynamicPublisher;

    @Autowired
    public void init(DomainEventEntryRepository domainEventEntryRepository, DomainEventEntryDynamicPublisher domainEventEntryDynamicPublisher) {
        DomainEventEntryListener.domainEventEntryRepository = domainEventEntryRepository;
        DomainEventEntryListener.domainEventEntryDynamicPublisher = domainEventEntryDynamicPublisher;
    }

    @PostPersist
    void onPersist(final DomainEventEntry entry) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                if (status == 0) {
                    CompletableFuture.runAsync(() -> DomainEventEntryListener.this.sendEvent(entry));
                }
            }
        });
    }

    @Transactional
    public void sendEvent(DomainEventEntry eventEntry) {
        boolean isSend;
        log.debug("Starting send...{}", (Object)eventEntry.getPayload());
        if (!eventEntry.isSent() && (isSend = domainEventEntryDynamicPublisher.sendEvent(eventEntry))) {
            eventEntry.setSent(true);
            domainEventEntryRepository.save(eventEntry);
        }
    }
}

